//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GLOBALIZATION_LOCALIZABLETEXT_H)
#define CANDERA_GLOBALIZATION_LOCALIZABLETEXT_H

#include <CanderaGlobalization/LocalizableTextBase.h>

namespace Candera { namespace Globalization { namespace Internal {
/// @addtogroup CanderaGlobalizationLocalizable
/// @{
/**
    *  Supports internationalization for constant strings.
    */
class LocalizableText : public LocalizableTextBase
{
    FEATSTD_TYPEDEF_BASE(LocalizableTextBase);

    public:
        LocalizableText(Localizable::Id id, const TChar* defaultString = 0);
        virtual ~LocalizableText();

    protected:
        virtual void ResolveString() const;

    private:
};
/// @}
}}}   // namespace Candera::Globalization::Internal
#endif  // CANDERA_GLOBALIZATION_LOCALIZABLETEXT_H
