//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "LocalizableText.h"
#include <CanderaGlobalization/Localizer.h>
#include <CanderaGlobalization/GlobalizationCultureManager.h>
#include <Candera/System/Diagnostics/Log.h>
#ifdef FEATSTD_THREADSAFETY_ENABLED
#include <FeatStd/Platform/CriticalSectionLocker.h>
#endif

namespace Candera { namespace Globalization { namespace Internal {
FEATSTD_LOG_SET_REALM(Candera::Diagnostics::LogRealm::CanderaGlobalization);

/******************************************************************************
 *  Constructor
 ******************************************************************************/
LocalizableText::LocalizableText(Localizable::Id id, const TChar* defaultString /* = 0 */) :
    Base(id, defaultString)
{
}

/******************************************************************************
 *  Destructor
 ******************************************************************************/
LocalizableText::~LocalizableText()
{
}

/******************************************************************************
 *  ResolveString
 ******************************************************************************/
void LocalizableText::ResolveString() const
{
#ifdef FEATSTD_THREADSAFETY_ENABLED
    FeatStd::Internal::CriticalSectionLocker lock(&GetCriticalSection());
#endif
    Localizer::SharedPointer localizer = GlobalizationCultureManager::GetInstance().GetLocalizer();
    if (!localizer.PointsToNull()) {
        m_cachedString = localizer->GetTextBaseString(GetId());
        if (0 == m_cachedString) {
            FEATSTD_LOG_WARN("Localized String with Id: %u could not be resolved.", GetId());
        }
    }
}
}}}   // namespace Candera::Globalization::Internal
