//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GLOBALIZATION_LOCALIZABLESTRINGDATABASE_H)
    #define CANDERA_GLOBALIZATION_LOCALIZABLESTRINGDATABASE_H

#include <FeatStd/Util/StringDataBase.h>
#include <CanderaGlobalization/Localizable.h>

namespace Candera { namespace Globalization { namespace Internal {
/// @addtogroup CanderaGlobalizationLocalizable
/// @{
class LocalizableTextBase;

/**
    *  Base class for all localizable string data objects which are attached to String.
    */
class LocalizableStringDataBase : public FeatStd::Internal::StringDataBase {
    public:
        /**
            *  Constructor
            */
        LocalizableStringDataBase();

        /**
            *  Destructor
            */
        virtual ~LocalizableStringDataBase();

        /**
            *  @return     The localizable text object which is linked to that string data object.
            */
        LocalizableTextBase* GetLocalizableText() { return m_text; }

        /**
            * @return       The character string to use for display, etc.
            */
        virtual const TChar* GetCString() const;

        /**
            * @return       The unique ID of this localizable.
            */
        virtual Localizable::Id GetId() const;

        /**
            * @return       Whether this localizable has changed.
            */
        virtual bool HasChanged() const;

        /**
            <summary>Gets the TChar character count.</summary>
            <returns>Number of TChar instances in the string.</returns>
            */
        virtual UInt32 GetCharCount();

        /**
            <summary>Gets the code point count.</summary>
            <returns>Number of code points in the string.</returns>
            */
        virtual UInt32 GetCodePointCount();

        virtual bool IsEmpty() const;

#ifdef FEATSTD_THREADSAFETY_ENABLED
        virtual FeatStd::Internal::CriticalSection* GetCriticalSection() const;
#endif
        virtual void Destroy() {};

    protected:
        LocalizableTextBase* m_text;

        /**
         *  Constructor
         */
        LocalizableStringDataBase(LocalizableTextBase* text);

        LocalizableStringDataBase(const LocalizableStringDataBase&);
        LocalizableStringDataBase& operator=(const LocalizableStringDataBase&);
};
/// @}
}}   // namespace Globalization::Internal
}   // namespace Candera
#endif  // CANDERA_GLOBALIZATION_LOCALIZABLESTRINGDATABASE_H
