//########################################################################
// (C) Candera GmbH
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Candera GmbH.
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "LocalizableStringDataBase.h"
#include <CanderaGlobalization/LocalizableText.h>

namespace Candera { namespace Globalization { namespace Internal {

/******************************************************************************
*  ctor
******************************************************************************/
LocalizableStringDataBase::LocalizableStringDataBase() : m_text(0)
{
}

LocalizableStringDataBase::LocalizableStringDataBase(LocalizableTextBase* text) : m_text(text)
{

}


/******************************************************************************
 *  GetCString
 ******************************************************************************/
LocalizableStringDataBase::~LocalizableStringDataBase()
{
}

/******************************************************************************
 *  GetCString
 ******************************************************************************/
const TChar* LocalizableStringDataBase::GetCString() const
{
    if (HasChanged()) {
        InvalidateCachedCharCount();
        InvalidateCachedCodePointCount();
    }
    return (0 != m_text) ? m_text->GetCString() : 0;
}

/******************************************************************************
 *  GetId
 ******************************************************************************/
Localizable::Id LocalizableStringDataBase::GetId() const
{
    if (HasChanged()) {
        InvalidateCachedCharCount();
        InvalidateCachedCodePointCount();
    }
    return (0 != m_text) ? m_text->GetId() : 0;
}

/******************************************************************************
 *  HasChanged
 ******************************************************************************/
bool LocalizableStringDataBase::HasChanged() const
{
    return (0 != m_text) ? m_text->HasChanged() : false;
}

/******************************************************************************
 *  GetCharCount
 ******************************************************************************/
UInt32 LocalizableStringDataBase::GetCharCount()
{
    if (HasChanged()) {
        InvalidateCachedCharCount();
        InvalidateCachedCodePointCount();
    }
    return StringDataBase::GetCharCount();
}

/******************************************************************************
 *  GetCodePointCount
 ******************************************************************************/
UInt32 LocalizableStringDataBase::GetCodePointCount()
{
    if (HasChanged()) {
        InvalidateCachedCharCount();
        InvalidateCachedCodePointCount();
    }
    return StringDataBase::GetCodePointCount();
}

bool LocalizableStringDataBase::IsEmpty() const
{
    return (0 != m_text) ? (m_text->GetCString() == 0) : true;
}

#ifdef FEATSTD_THREADSAFETY_ENABLED
FeatStd::Internal::CriticalSection* LocalizableStringDataBase::GetCriticalSection() const
{
    return (0 != m_text) ? &m_text->GetCriticalSection() : 0;
}
#endif

}}} // namespace Candera::Globalization::Internal
