//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "LocalizableStringData.h"
#include <FeatStd/Diagnostics/Debug.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <CanderaGlobalization/LocalizableText.h>
#include <FeatStd/Util/PointerUtil.h>
#include <FeatStd/Util/Alignment.h>

namespace Candera { namespace Globalization { namespace Internal {

/******************************************************************************
 *  Destructor
 ******************************************************************************/
LocalizableStringData::~LocalizableStringData()
{
    MemoryManagement::DestructObject<LocalizableText>(m_text);
}

/******************************************************************************
 *  Create
 ******************************************************************************/
LocalizableStringData* LocalizableStringData::Create(Localizable::Id id, const TChar* defaultString)
{
    FEATSTD_COMPILETIME_ASSERT(sizeof(LocalizableStringData) % 4 == 0);
    FEATSTD_COMPILETIME_ASSERT(sizeof(LocalizableText) % 4 == 0);

    const UInt32 n = sizeof(LocalizableStringData) + sizeof(LocalizableText);
    UInt8* pInstance = CANDERA_NEW_ARRAY(UInt8, n);

    LocalizableStringData* instance = MemoryManagement::ConstructObject<LocalizableStringData>(pInstance);

    if (0 != instance) {
        UInt8* pText = FeatStd::Internal::PointerAdd<UInt8*>(instance, sizeof(LocalizableStringData));
        FEATSTD_DEBUG_ASSERT(FeatStd::Internal::DefaultAlignment::CheckAddress(pText));

        FEATSTD_LINT_NEXT_EXPRESSION(586, "placement operator new regarded to be safe")
            instance->m_text = MemoryManagement::ConstructObject<LocalizableText>(pText, id, defaultString);
    }
    return instance;
}

void LocalizableStringData::Destroy()
{
    MemoryManagement::DestructObject<LocalizableStringData>(this);
    CANDERA_DELETE_ARRAY(FeatStd::Internal::PointerToPointer<UInt8*>(this));
}

}}}   // namespace Candera::Globalization::Internal
