//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Localizable.h"
#include <CanderaGlobalization/CultureManager.h>

namespace Candera { namespace Globalization { namespace Internal {
/******************************************************************************
 *  Constructor
 ******************************************************************************/
Localizable::Localizable(Id id) :
    m_id(id)
{
    CultureManager::GetInstance().AddCultureChangeListener(this);
}

/******************************************************************************
 *  Destructor
 ******************************************************************************/
Localizable::~Localizable()
{
    static_cast<void>(CultureManager::GetInstance().RemoveCultureChangeListener(this));
}

/******************************************************************************
 *  OnCultureChanged
 ******************************************************************************/
void Localizable::OnCultureChanged(const Culture& /*culture*/)
{
}
}}}   // namespace Candera::Globalization::Internal
