//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "LanguagePack.h"
#include <Candera/System/MemoryManagement/MemoryManagement.h>

namespace Candera {
    namespace Globalization {

using namespace Candera::Globalization::Internal;

/******************************************************************************
 *  Constructor
 ******************************************************************************/
LanguagePack::LanguagePack(Handle hdl) :
    m_hdl(hdl)
{
}

/******************************************************************************
 *  Destructor
 ******************************************************************************/
LanguagePack::~LanguagePack()
{
    m_hdl = 0;
}

/******************************************************************************
 *  Create
 ******************************************************************************/
LanguagePack::SharedPointer LanguagePack::Create(Handle hdl)
{
    return LanguagePack::SharedPointer(FEATSTD_NEW(LanguagePack)(hdl));
}

/******************************************************************************
 *  GetBaseString
 ******************************************************************************/
const TChar* LanguagePack::GetBaseString(Localizable::Id id) const
{
    const TextTableEntry* entry = GetEntry(id);

    if (entry != 0) {
        const TChar* addr = reinterpret_cast<const TChar*>(entry) + 4;
        return addr + entry->m_textOffset;
    }

    return 0;
}

/******************************************************************************
 *  GetTextType
 ******************************************************************************/
Localizer::TextType LanguagePack::GetTextType(Localizable::Id id) const
{
    const TextTableEntry* entry = GetEntry(id);

    return (entry != 0) ? static_cast<Localizer::TextType>(entry->m_textType) : Localizer::_undefined;
}

/******************************************************************************
 *  GetEntry
 ******************************************************************************/
const LanguagePack::TextTableEntry* LanguagePack::GetEntry(Localizable::Id id) const
{
    const TextTableEntry* rc = 0;

    Int32 leftIndex = 0;
    Int32 rightIndex = static_cast<Int32>(GetTextTableHeader().m_textCount) - 1;

    while ((leftIndex <= rightIndex) && (rc == 0)) {
        Int32 halfIndex = (leftIndex + rightIndex) / 2;

        const TextTableEntry& entry = GetTextTableEntry(halfIndex);
        Localizable::Id halfId = entry.m_textId;
        if (halfId == id) {
            rc = &entry;
        }
        else {
            if (halfId < id) {
                leftIndex = halfIndex + 1;
            }
            else {
                rightIndex = halfIndex - 1;
            }
        }
    }

    return rc;
}
    }   // namespace Globalization
}   // namespace Candera
