//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <CanderaGlobalization/ParameterizedLocalizableStringDataFactory.h>

#include <FeatStd/Util/StaticObject.h>
#include <CanderaGlobalization/DataBinding/ParameterizedLocalizableStringData.h>
#include <CanderaGlobalization/DataBinding/ParameterizedLocalizableText.h>

namespace Candera { namespace Globalization { namespace Internal {

    ParameterizedLocalizableStringDataFactory::ParameterizedLocalizableStringDataFactory()
    {
    }
    
LocalizableStringDataBase* ParameterizedLocalizableStringDataFactory::CreateStringData(SizeType id) const
{
    return ParameterizedLocalizableStringData::Create(id);
}

ParameterizedLocalizableStringDataFactory& ParameterizedLocalizableStringDataFactory::GetInstance()
{
        FEATSTD_UNSYNCED_STATIC_OBJECT(ParameterizedLocalizableStringDataFactory, s_instance);
        return s_instance;
}
    static ParameterizedLocalizableStringDataFactory& s_forceInitInstance = ParameterizedLocalizableStringDataFactory::GetInstance();
}}} // namespace Candera::Globalization::Internal
