//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GLOBALIZATION_PARAMETERIZEDLOCALIZABLESTRINGDATA_H)
#define CANDERA_GLOBALIZATION_PARAMETERIZEDLOCALIZABLESTRINGDATA_H

#include <CanderaGlobalization/LocalizableStringData.h>

namespace Candera { namespace Globalization { namespace Internal {
/// @addtogroup CanderaGlobalizationLocalizable
/// @{
/**
*  Localizable string data object which can have parameters and conditions.
    */
class ParameterizedLocalizableStringData : public LocalizableStringDataBase {
    FEATSTD_TYPEDEF_BASE(LocalizableStringDataBase);

    public:
        /**
            *  Constructor
            */
        ParameterizedLocalizableStringData() {};

        /**
            *  Destructor
            */
        virtual ~ParameterizedLocalizableStringData();

        /**
            * Create method which allocates contiguous memory for object and it's memebers
            * @param  id              The unique identifier for the text.
            */
        static ParameterizedLocalizableStringData* Create(LocalizableId id);
        virtual void  Destroy();

    private:
        ParameterizedLocalizableStringData(const ParameterizedLocalizableStringData&);
        ParameterizedLocalizableStringData& operator=(const ParameterizedLocalizableStringData&);
};
/// @}
}}}   // namespace Candera
#endif  // CANDERA_GLOBALIZATION_PARAMETERIZEDLOCALIZABLESTRINGDATA_H
