//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ParameterizedLocalizableStringData.h"
#include <FeatStd/Diagnostics/Debug.h>

#include <CanderaGlobalization/DataBinding/ParameterizedLocalizableText.h>

#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <FeatStd/Util/PointerUtil.h>
#include <FeatStd/Util/Alignment.h>

namespace Candera { namespace Globalization { namespace Internal {
/******************************************************************************
 * Destructor
 ******************************************************************************/
ParameterizedLocalizableStringData::~ParameterizedLocalizableStringData()
{
    MemoryManagement::DestructObject<ParameterizedLocalizableText>(m_text);
}

ParameterizedLocalizableStringData* ParameterizedLocalizableStringData::Create(LocalizableId id)
{
    FEATSTD_COMPILETIME_ASSERT(sizeof(ParameterizedLocalizableStringData) % 4 == 0);
    FEATSTD_COMPILETIME_ASSERT(sizeof(ParameterizedLocalizableText) % 4 == 0);

    const UInt32 n = sizeof(ParameterizedLocalizableStringData) + sizeof(ParameterizedLocalizableText);
    UInt8* pInstance = CANDERA_NEW_ARRAY(UInt8, n);

    ParameterizedLocalizableStringData* instance = MemoryManagement::ConstructObject<ParameterizedLocalizableStringData>(pInstance);

    if (0 != instance) {
        UInt8* pText = FeatStd::Internal::PointerAdd<UInt8*>(instance, sizeof(ParameterizedLocalizableStringData));
        FEATSTD_DEBUG_ASSERT(FeatStd::Internal::DefaultAlignment::CheckAddress(pText));

        instance->m_text = MemoryManagement::ConstructObject<ParameterizedLocalizableText>(pText, id);
    }
    return instance;
}

void ParameterizedLocalizableStringData::Destroy()
{
    MemoryManagement::DestructObject<ParameterizedLocalizableStringData>(this);
    CANDERA_DELETE_ARRAY(FeatStd::Internal::PointerToPointer<UInt8*>(this));
}

}}}   //namespace Candera::Globalization::Internal
