//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Formatter.h"
#include <FeatStd/Diagnostics/Debug.h>

#include <FeatStd/Util/String.h>

#include <stdio.h>

#include <Courier/DataBinding/DataItemValue.h>
#include <FeatStd/Util/String.h>

#ifdef FEATSTD_THREADSAFETY_ENABLED
#include <FeatStd/Platform/CriticalSectionLocker.h>
#endif

using FeatStd::String;
using Courier::DataItemValue;

namespace Candera { namespace Globalization {
/******************************************************************************
 *  Formatter
 ******************************************************************************/
Formatter::Formatter()
{
}

/******************************************************************************
 *  ~Formatter
 ******************************************************************************/
Formatter::~Formatter()
{
}

/******************************************************************************
 *  StringFormatter
 ******************************************************************************/
Candera::UInt16 StringFormatter::Format(const DataItemValue& value, TChar* dst, UInt16 maxLength)
{
    CANDERA_RELEASE_UNUSED_PARAMETER(maxLength);

#ifdef FEATSTD_THREADSAFETY_ENABLED
    FeatStd::Internal::CriticalSectionLocker lock(value.GetValue<String>()->GetCriticalSection());
#endif
    Int length = sprintf(reinterpret_cast<Char*>(dst), "%s", value.GetValue<String>()->GetCString());
    FEATSTD_DEBUG_ASSERT(length >= 0 && length <= maxLength);
    return static_cast<UInt16>(length);
}

/******************************************************************************
 *  Int32Formatter
 ******************************************************************************/
Int32Formatter::Int32Formatter() :
    m_formatString("%d")
{
}

/******************************************************************************
 *  ~Int32Formatter
 ******************************************************************************/
Int32Formatter::~Int32Formatter()
{
    m_formatString = 0;
}

/******************************************************************************
 *  Format
 ******************************************************************************/
UInt16 Int32Formatter::Format(const DataItemValue& value, TChar* dst, UInt16 maxLength)
{
    CANDERA_RELEASE_UNUSED_PARAMETER(maxLength);

    Int length = sprintf(reinterpret_cast<Char*>(dst), reinterpret_cast<const Char*>(m_formatString), *value.GetValue<Int32>());
    FEATSTD_DEBUG_ASSERT(length >= 0 && length <= maxLength);
    return static_cast<UInt16>(length);
}

/******************************************************************************
 *  FloatFormatter
 ******************************************************************************/
FloatFormatter::FloatFormatter() :
    m_formatString("%f")
{
}

/******************************************************************************
 *  ~FloatFormatter
 ******************************************************************************/
FloatFormatter::~FloatFormatter()
{
    m_formatString = 0;
}

/******************************************************************************
 *  Format
 ******************************************************************************/
UInt16 FloatFormatter::Format(const DataItemValue& value, TChar* dst, UInt16 maxLength)
{
    CANDERA_RELEASE_UNUSED_PARAMETER(maxLength);

    Int length = sprintf(reinterpret_cast<Char*>(dst), reinterpret_cast<const Char*>(m_formatString), *value.GetValue<Float>());
    FEATSTD_DEBUG_ASSERT(length >= 0 && length <= maxLength);
    return static_cast<UInt16>(length);
}

/******************************************************************************
 *  BoolFormatter
 ******************************************************************************/
BoolFormatter::BoolFormatter() :
    m_trueString(reinterpret_cast<const TChar*>("1")),
    m_falseString(reinterpret_cast<const TChar*>("0"))
{
}

/******************************************************************************
 *  ~BoolFormatter
 ******************************************************************************/
BoolFormatter::~BoolFormatter()
{
    m_trueString = 0;
    m_falseString = 0;
}

/******************************************************************************
 *  Format
 ******************************************************************************/
UInt16 BoolFormatter::Format(const DataItemValue& value, TChar* dst, UInt16 maxLength)
{
    CANDERA_RELEASE_UNUSED_PARAMETER(maxLength);

    const TChar* boolString = *value.GetValue<bool>() ? m_trueString : m_falseString;
    Int length = 0;
    if (boolString != 0) {
        length = sprintf(reinterpret_cast<Char*>(dst), "%s", boolString);
        FEATSTD_DEBUG_ASSERT(length >= 0 && length <= maxLength);
    }
    return static_cast<UInt16>(length);
}
}}
