//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#ifndef CANDERA_TOUCH_SESSION_EVENT_DISPATCH_RESULT_H
#define CANDERA_TOUCH_SESSION_EVENT_DISPATCH_RESULT_H

#include <Candera/Environment.h>
#include <CanderaBehavior/Touch/TouchSession.h>
#include <CanderaBehavior/BehaviorBase/EventDispatchResult.h>

namespace Candera {

    class TouchSessionEventDispatchResult : public EventDispatchResult
    {
    public:
        FEATSTD_RTTI_DECLARATION();
        enum TouchUsage
        {
            Consumer,
            Observer
        };

        TouchSessionEventDispatchResult(TouchSession& touchSession) :
            m_touchSession(touchSession)
        {
        }

        virtual ~TouchSessionEventDispatchResult()
        {
        }

        TouchSession& GetTouchSession()
        {
            return m_touchSession;
        }

        bool IsTouched() const
        {
            return m_touched;
        }

        void SetTouched(bool touched)
        {
            m_touched = touched;
        }

        TouchUsage GetTouchUsage() const
        {
            return m_touchUsage;
        }

        void SetTouchUsage(TouchUsage touchUsage)
        {
            m_touchUsage = touchUsage;
        }

    private:
        FEATSTD_MAKE_CLASS_STATIC(TouchSessionEventDispatchResult);
        FEATSTD_MAKE_CLASS_UNCOPYABLE(TouchSessionEventDispatchResult);
        TouchSession& m_touchSession;
        FeatStd::Initialized<bool> m_touched;
        FeatStd::Initialized<TouchUsage> m_touchUsage;
    };
}
 
#endif //CANDERA_TOUCH_SESSION_EVENT_DISPATCH_RESULT_H
