//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#include "TouchSession.h"


namespace Candera {
    FEATSTD_RTTI_DEFINITION(TouchSession::UpdateEvent, FeatStd::Event)
    FEATSTD_RTTI_DEFINITION(TouchSession::UpdateEventDispatchResult, Candera::EventDispatchResult)

    static TouchSession &TouchSessionDefaultInstance()
    {
        FEATSTD_UNSYNCED_STATIC_OBJECT(TouchSession, s_touchSessionDefaultInstance);
        return s_touchSessionDefaultInstance;
    }

    static TouchSession* &TouchSessionInstance()
    {
        FEATSTD_UNSYNCED_STATIC_OBJECT(TouchSession*, s_touchSessionInstance, 0);
        return s_touchSessionInstance;
    }

    TouchSession& TouchSession::GetInstance()
    {
        TouchSession* instance = TouchSessionInstance();
        if (0 == instance) {
            return TouchSessionDefaultInstance();
        }
        return *instance;
    }

    void TouchSession::SetInstance(TouchSession* instance)
    {
        TouchSessionInstance() = instance;
    }

    void TouchSession::Register(Behavior& /*behavior*/, FeatStd::Int /*mask*/)
    {
    }

    void TouchSession::Deregister(Behavior& /*behavior*/, FeatStd::Int /*mask*/)
    {
    }

    void TouchSession::OnEvent(const FeatStd::Event& /*event*/, EventDispatchResult& /*dispatchResult*/)
    {
    }
}
