//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#ifndef CANDERA_TOUCH_INFO_H
#define CANDERA_TOUCH_INFO_H

#include <Candera/Environment.h>

namespace Candera {
    /** @addtogroup BehaviorTouch
    *  @{
    */
    /**
    * @brief Description
    **/

    // TODO: adapt Courier IViewHandler.h by replace the "struct TouchInfo" with "using Candera::TouchInfo;"
    // the touch info in Courier is then the same as in Candera.
    /** Touch information which is used for detection of a touched widget.
    */
    struct TouchInfo
    {
        enum State
        {
            /** The pointer is currently moved. Before the pointer has been moved it had the state State::Down. */
            Move = 1,
            /** The pointer is currently put down. After this state either several State::Move states or the state State::Up are possible. */
            Down = 2,
            /** The pointer is currently lifted. Before this the pointer had the State::Down or State::Moving state. */
            Up = 4,
            /** The pointer is currently at a hover distance.*/
            Hover = 8
        };

        TouchInfo(State state, Int32 x, Int32 y, SizeType timestamp, UInt8 pointerId, SizeType sourceId);

        TouchInfo(const TouchInfo & info);

        State m_state;
        Int32 m_x;
        Int32 m_y;
        SizeType m_timestamp;
        UInt8 m_pointerId;
        SizeType m_sourceId;

    private:
        FEATSTD_MAKE_CLASS_STATIC(TouchInfo);
    };
/** @} */
}
 
#endif //CANDERA_BEHAVIOR_2D_H
