//########################################################################
// (C)  Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_KEYBOARD_MODIFIER_H
#define CANDERA_KEYBOARD_MODIFIER_H

#include <Candera/Environment.h>
#include <Candera/System/MetaInfo/EnumDataTypeInternal.h>

namespace Candera {

    namespace KeyModifierEnum {
        // =========================================================================
        enum Enum {
            None,
            Key_Shift,
            Key_Alt,
            Key_Ctrl,
            Key_CapsLock,
            Key_Num
        };
    } // namespace DragDropEventType
} // namespace Candera

CANDERA_INTERNAL_ENUM_METAINFO_BEGIN(::Candera::KeyModifierEnum::Enum, _Candera_KeyModifierEnum_Enum)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(None)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Shift)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Alt)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Ctrl)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_CapsLock)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Num)
CANDERA_INTERNAL_ENUM_METAINFO_END()
namespace Candera {
class KeyEvent;
class KeyboardModifier
{
public:
    /**
    * Get the KeyboardModifier singleton instance.
    */
    static KeyboardModifier& GetInstance();

    /**
    * Set a custom KeyboardModifier singleton instance.
    */
    static void SetInstance(KeyboardModifier* keyboardModifier);

    /**
     * Default constructor of KeyboardModifier.
     */
    KeyboardModifier();

    /**
     * Destructor of KeyboardModifier.
     */
    virtual ~KeyboardModifier();

    /**
     * SetModifier changes the Modifier bitmask according to the new modifier. If the bitmask is changed it returns a new KeyEvent with the current Modifierbitmask.
     * Note that there are two types of modifier. One type (e.g. Shift) is true as long as the key is pressed. The second type is true as long as the key gets pressed for the second time.
     * @param keyEvent Candera::KeyEvent& event with the KeyCode which gets checked.
     */
     Candera::KeyEvent SetModifier(const Candera::KeyEvent& keyEvent);
protected:
    FeatStd::UInt16 m_modifierBitmask;
    FeatStd::UInt16 m_modifierCounter[Candera::KeyModifierEnum::Key_Num];

private:
    FEATSTD_MAKE_CLASS_UNCOPYABLE(KeyboardModifier);
};

} // namespace Candera

#endif // KeyboardModifier_H
