//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_KEY_EVENT_H
#define CANDERA_KEY_EVENT_H

#include <Candera/Environment.h>
#include <CanderaBehavior/Touch/KeyboardModifier.h>
#include <FeatStd/Event/Event.h>
#include <Candera/System/MetaInfo/EnumDataTypeInternal.h>
#include <FeatStd/Util/StringBuffer.h>

namespace Candera {
        namespace KeyboardKeyCode {
            // =========================================================================
            /** KeyboardKeyCode enumeration values are representing the possible KeyCodes. */
            enum Enum {
                /** */
                Key_None,
                /** */
                Key_Back = 8,
                /** */
                Key_Tab,
                /** */
                Key_Clear = 12,
                /** */
                Key_Enter,
                /** */
                Key_Shift = 16,
                /** */
                Key_Control,
                /** */
                Key_Alt,
                /** */
                Key_Pause,
                /** */
                Key_Capital,
                /** */
                Key_Escape = 27,
                /** */
                Key_Space = 32,
                /** */
                Key_PageUp,
                /** */
                Key_PageDown,
                /** */
                Key_End,
                /** */
                Key_Home,
                /** */
                Key_LeftArrow,
                /** */
                Key_UpArrow,
                /** */
                Key_RightArrow,
                /** */
                Key_DownArrow,
                /** */
                Key_Print = 42,
                /** */
                Key_Insert = 45,
                /** */
                Key_Del,
                /** */
                Key_0 = 48,
                /** */
                Key_1,
                /** */
                Key_2,
                /** */
                Key_3,
                /** */
                Key_4,
                /** */
                Key_5,
                /** */
                Key_6,
                /** */
                Key_7,
                /** */
                Key_8,
                /** */
                Key_9,
                /** */
                Key_A = 65,
                /** */
                Key_B,
                /** */
                Key_C,
                /** */
                Key_D,
                /** */
                Key_E,
                /** */
                Key_F,
                /** */
                Key_G,
                /** */
                Key_H,
                /** */
                Key_I,
                /** */
                Key_J,
                /** */
                Key_K,
                /** */
                Key_L,
                /** */
                Key_M,
                /** */
                Key_N,
                /** */
                Key_O,
                /** */
                Key_P,
                /** */
                Key_Q,
                /** */
                Key_R,
                /** */
                Key_S,
                /** */
                Key_T,
                /** */
                Key_U,
                /** */
                Key_V,
                /** */
                Key_W,
                /** */
                Key_X,
                /** */
                Key_Y,
                /** */
                Key_Z,
                /** */
                Key_Num0 = 96,
                /** */
                Key_Num1,
                /** */
                Key_Num2,
                /** */
                Key_Num3,
                /** */
                Key_Num4,
                /** */
                Key_Num5,
                /** */
                Key_Num6,
                /** */
                Key_Num7,
                /** */
                Key_Num8,
                /** */
                Key_Num9,
                /** */
                Key_Multiply = 106,
                /** */
                Key_Add,
                /** */
                Key_Separator,
                /** */
                Key_Subtract,
                /** */
                Key_Decimal,
                /** */
                Key_Divide,
                /** */
                Key_F1 = 112,
                /** */
                Key_F2,
                /** */
                Key_F3,
                /** */
                Key_F4,
                /** */
                Key_F5,
                /** */
                Key_F6,
                /** */
                Key_F7,
                /** */
                Key_F8,
                /** */
                Key_F9,
                /** */
                Key_F10,
                /** */
                Key_F11,
                /** */
                Key_F12,
                /** */
                Key_NumLock = 144,
                /** */
                Key_ScrollLock = 145,
                /** */
                Key_OEM1 = 186,
                /** */
                Key_Plus,
                /** */
                Key_Comma,
                /** */
                Key_Minus,
                /** */
                Key_Period,
                /** */
                Key_OEM2 = 191,
                /** */
                Key_OEM3,
                /** */
                Key_OEM4 = 219,
                /** */
                Key_OEM5,
                /** */
                Key_OEM6,
                /** */
                Key_OEM7
            };
        } // namespace KeyboardKeyCode
} // namespace Candera

CANDERA_INTERNAL_ENUM_METAINFO_BEGIN(::Candera::KeyboardKeyCode::Enum, _CgiStudioControl_KeyboardKeyCode_Enum)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_None)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(Key_Back, 8)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Tab)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(Key_Clear, 12)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Enter)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(Key_Shift, 16)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Control)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Alt)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Pause)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Capital)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(Key_Escape, 27)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(Key_Space, 32)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_PageUp)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_PageDown)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_End)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Home)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_LeftArrow)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_UpArrow)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_RightArrow)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_DownArrow)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(Key_Print, 42)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(Key_Insert, 45)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Del)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(Key_0, 48)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_1)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_2)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_3)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_4)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_5)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_6)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_7)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_8)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_9)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(Key_A, 65)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_B)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_C)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_D)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_E)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_F)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_G)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_H)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_I)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_J)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_K)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_L)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_M)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_N)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_O)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_P)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Q)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_R)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_S)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_T)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_U)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_V)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_W)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_X)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Y)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Z)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(Key_Num0, 96)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Num1)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Num2)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Num3)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Num4)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Num5)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Num6)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Num7)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Num8)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Num9)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(Key_Multiply, 106)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Add)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Separator)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Subtract)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Decimal)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Divide)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(Key_F1, 112)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_F2)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_F3)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_F4)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_F5)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_F6)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_F7)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_F8)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_F9)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_F10)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_F11)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_F12)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(Key_NumLock, 144)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(Key_ScrollLock, 145)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(Key_OEM1, 186)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Plus)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Comma)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Minus)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_Period)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(Key_OEM2, 191)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_OEM3)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM_VALUE(Key_OEM4, 219)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_OEM5)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_OEM6)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Key_OEM7)
CANDERA_INTERNAL_ENUM_METAINFO_END()

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
    namespace FeatStd {
        template<> ::FeatStd::UInt32 StringBufferAppender<Candera::KeyboardKeyCode::Enum >::Append(::FeatStd::StringBuffer& stringBuffer, Candera::KeyboardKeyCode::Enum const & object);
    } // namespace FeatStd
#endif

namespace Candera {
    class KeyEvent : public FeatStd::Event
    {
        friend class Candera::KeyboardModifier;

    public:
        FEATSTD_RTTI_DECLARATION();
        /**
        *  Constructor.
        */
        KeyEvent(){}
        /**
        *  Destructor.
        */
        virtual ~KeyEvent(){}
        /**
        *  Constructor.
        *  @param modifier Candera::KeyModifierEnum Modifier which will be sent via the KeyEvent (e.g. Shift, CapsLock).
        *  @param keyState bool State of the key. True means that the key is in Down state, false means Up state.
        */
        KeyEvent(Candera::KeyModifierEnum::Enum modifier, bool keyState);
        /**
        *  Constructor.
        *  @param keyCode modifier FeatStd::UInt16 KeyCode which will be sent via the KeyEvent. Used if the key is no character or modifier.
        *  @param keyState bool State of the key. True means that the key is in Down state, false means Up state.
        */
        KeyEvent(Candera::KeyboardKeyCode::Enum keyCode, bool keyState);
        /**
        *  Copy constructor.
        *  @param keyEvent The other KeyEvent that is copied.
        */
        KeyEvent(const KeyEvent& keyEvent);

        KeyEvent& operator=(const KeyEvent& keyEvent);

        Candera::KeyModifierEnum::Enum GetModifier()const{
            return m_modifier;
        }
        FeatStd::UInt16 GetModifierBitmask()const{
            return m_modifierBitmask;
        }
        bool GetKeyState() const{
            return m_keyState;
        }
        Candera::KeyboardKeyCode::Enum GetKeyCode() const{
            return m_keyCode;
        }

        static Candera::KeyboardKeyCode::Enum WaylandKeyCodeToKeyboardKeyCode(FeatStd::UInt16 index);

    private:
        Candera::KeyboardKeyCode::Enum m_keyCode;
        Candera::KeyModifierEnum::Enum m_modifier;
        FeatStd::UInt16 m_modifierBitmask;
        bool m_keyState;

    };
}
#endif //CANDERA_KEY_EVENT_H
