//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <CanderaBehavior/Touch/KeyEvent.h>
#include <CanderaBehavior/BehaviorBase/BehaviorMetaInfo.h>
#include <FeatStd/Util/Rtti.h>
#include <Candera/TextEngine/Types.h>

CdaEventDef(Candera::KeyEvent)
CdaReadableName("Key Event")
CdaDescription("Event emitted when a key is pressed or released.")
CdaCategory("Control")
CdaEventSortOrder((FeatStd::Internal::Limits<FeatStd::Int32>::Min() + 50))
CdaEventDefEnd()

namespace Candera {
    FEATSTD_RTTI_DEFINITION(Candera::KeyEvent, Event)
    KeyEvent::KeyEvent(Candera::KeyboardKeyCode::Enum keyCode, bool keyState) :
    m_keyCode(keyCode),
    m_modifier(Candera::KeyModifierEnum::None),
    m_modifierBitmask(),
    m_keyState(keyState)
    {
                switch (keyCode)
                {
                    //VK_SHIFT
                case KeyboardKeyCode::Key_Shift: m_modifier = Candera::KeyModifierEnum::Key_Shift;
                    break;
                    //VK_CONTROL
                case KeyboardKeyCode::Key_Control: m_modifier = Candera::KeyModifierEnum::Key_Ctrl;
                    break;
                    //VK_CAPITAL
                case KeyboardKeyCode::Key_Capital: m_modifier = Candera::KeyModifierEnum::Key_CapsLock;
                    break;
                    //VK_MENU
                case KeyboardKeyCode::Key_Alt: m_modifier = Candera::KeyModifierEnum::Key_Alt;
                    break;
                    //VK_NUMLOCK
                case KeyboardKeyCode::Key_NumLock: m_modifier = Candera::KeyModifierEnum::Key_Num;
                    break;
                default:
                    break;
                }
        }

    KeyEvent::KeyEvent(Candera::KeyModifierEnum::Enum modifier, bool keyState) :
        m_keyCode(KeyboardKeyCode::Key_Shift),
        m_modifier(modifier),
        m_modifierBitmask(),
        m_keyState(keyState)
    {
        switch (modifier)
        {
            //VK_SHIFT
        case Candera::KeyModifierEnum::Key_Shift: m_keyCode = KeyboardKeyCode::Key_Shift;
            break;
            //VK_CONTROL
        case Candera::KeyModifierEnum::Key_Ctrl: m_keyCode = KeyboardKeyCode::Key_Control;
            break;
            //VK_CAPITAL
        case Candera::KeyModifierEnum::Key_CapsLock: m_keyCode = KeyboardKeyCode::Key_Capital;
            break;
            //VK_MENU
        case Candera::KeyModifierEnum::Key_Alt: m_keyCode = KeyboardKeyCode::Key_Alt;
            break;
            //VK_NUMLOCK
        case Candera::KeyModifierEnum::Key_Num: m_keyCode = KeyboardKeyCode::Key_NumLock;
            break;
        default:
            break;
        }
    }

    KeyEvent::KeyEvent(const KeyEvent& keyEvent) : FeatStd::Event()
    {
        m_keyCode = keyEvent.m_keyCode;
        m_keyState = keyEvent.m_keyState;
        m_modifier = keyEvent.m_modifier;
        m_modifierBitmask = keyEvent.m_modifierBitmask;
    }

    KeyEvent& KeyEvent::operator=(const KeyEvent& keyEvent){
        if (&keyEvent != this) {
            m_keyCode = keyEvent.GetKeyCode();
            m_keyState = keyEvent.GetKeyState();
            m_modifier = keyEvent.GetModifier();
            m_modifierBitmask = keyEvent.GetModifierBitmask();
        }
        return *this;
    }

    struct KeyCodeWaylandArray {
        Candera::KeyboardKeyCode::Enum waylandKeyInputToKeyCode[119];
    };

    const KeyCodeWaylandArray GetKeyCodeWaylandArray()
    {
        const KeyCodeWaylandArray waylandKeyInputToKeyCode =
        {{
            Candera::KeyboardKeyCode::Key_Escape,
            Candera::KeyboardKeyCode::Key_1,
            Candera::KeyboardKeyCode::Key_2,
            Candera::KeyboardKeyCode::Key_3,
            Candera::KeyboardKeyCode::Key_4,
            Candera::KeyboardKeyCode::Key_5,
            Candera::KeyboardKeyCode::Key_6,
            Candera::KeyboardKeyCode::Key_7,
            Candera::KeyboardKeyCode::Key_8,
            Candera::KeyboardKeyCode::Key_9,
            Candera::KeyboardKeyCode::Key_0,
            Candera::KeyboardKeyCode::Key_Minus,
            Candera::KeyboardKeyCode::Key_Plus,
            Candera::KeyboardKeyCode::Key_Back,
            Candera::KeyboardKeyCode::Key_Tab,
            Candera::KeyboardKeyCode::Key_Q,
            Candera::KeyboardKeyCode::Key_W,
            Candera::KeyboardKeyCode::Key_E,
            Candera::KeyboardKeyCode::Key_R,
            Candera::KeyboardKeyCode::Key_T,
            Candera::KeyboardKeyCode::Key_Z,
            Candera::KeyboardKeyCode::Key_U,
            Candera::KeyboardKeyCode::Key_I,
            Candera::KeyboardKeyCode::Key_O,
            Candera::KeyboardKeyCode::Key_P,
            Candera::KeyboardKeyCode::Key_OEM4,
            Candera::KeyboardKeyCode::Key_OEM6,
            Candera::KeyboardKeyCode::Key_Enter,
            Candera::KeyboardKeyCode::Key_Control,
            Candera::KeyboardKeyCode::Key_A,
            Candera::KeyboardKeyCode::Key_S,
            Candera::KeyboardKeyCode::Key_D,
            Candera::KeyboardKeyCode::Key_F,
            Candera::KeyboardKeyCode::Key_G,
            Candera::KeyboardKeyCode::Key_H,
            Candera::KeyboardKeyCode::Key_J,
            Candera::KeyboardKeyCode::Key_K,
            Candera::KeyboardKeyCode::Key_L,
            Candera::KeyboardKeyCode::Key_OEM1,
            Candera::KeyboardKeyCode::Key_OEM7,
            Candera::KeyboardKeyCode::Key_OEM3,
            Candera::KeyboardKeyCode::Key_Shift,
            Candera::KeyboardKeyCode::Key_OEM5,
            Candera::KeyboardKeyCode::Key_Z,
            Candera::KeyboardKeyCode::Key_X,
            Candera::KeyboardKeyCode::Key_C,
            Candera::KeyboardKeyCode::Key_V,
            Candera::KeyboardKeyCode::Key_B,
            Candera::KeyboardKeyCode::Key_N,
            Candera::KeyboardKeyCode::Key_M,
            Candera::KeyboardKeyCode::Key_Comma,
            Candera::KeyboardKeyCode::Key_Period,
            Candera::KeyboardKeyCode::Key_OEM2,
            Candera::KeyboardKeyCode::Key_Shift,
            Candera::KeyboardKeyCode::Key_Alt,
            Candera::KeyboardKeyCode::Key_Alt,
            Candera::KeyboardKeyCode::Key_Space,
            Candera::KeyboardKeyCode::Key_Capital,
            Candera::KeyboardKeyCode::Key_F1,
            Candera::KeyboardKeyCode::Key_F2,
            Candera::KeyboardKeyCode::Key_F3,
            Candera::KeyboardKeyCode::Key_F4,
            Candera::KeyboardKeyCode::Key_F5,
            Candera::KeyboardKeyCode::Key_F6,
            Candera::KeyboardKeyCode::Key_F7,
            Candera::KeyboardKeyCode::Key_F8,
            Candera::KeyboardKeyCode::Key_F9,
            Candera::KeyboardKeyCode::Key_F10,
            Candera::KeyboardKeyCode::Key_NumLock,
            Candera::KeyboardKeyCode::Key_ScrollLock,
            Candera::KeyboardKeyCode::Key_Num7,
            Candera::KeyboardKeyCode::Key_Num8,
            Candera::KeyboardKeyCode::Key_Num9,
            Candera::KeyboardKeyCode::Key_Subtract,
            Candera::KeyboardKeyCode::Key_Num4,
            Candera::KeyboardKeyCode::Key_Num5,
            Candera::KeyboardKeyCode::Key_Num6,
            Candera::KeyboardKeyCode::Key_Add,
            Candera::KeyboardKeyCode::Key_Num1,
            Candera::KeyboardKeyCode::Key_Num2,
            Candera::KeyboardKeyCode::Key_Num3,
            Candera::KeyboardKeyCode::Key_Num0,
            Candera::KeyboardKeyCode::Key_Decimal,
            Candera::KeyboardKeyCode::Key_None,     // not reserved
            Candera::KeyboardKeyCode::Key_None,     // not reserved
            Candera::KeyboardKeyCode::Key_None,     // not reserved
            Candera::KeyboardKeyCode::Key_F11,
            Candera::KeyboardKeyCode::Key_F12,
            Candera::KeyboardKeyCode::Key_None,     // not reserved
            Candera::KeyboardKeyCode::Key_None,     // not reserved
            Candera::KeyboardKeyCode::Key_None,     // not reserved
            Candera::KeyboardKeyCode::Key_None,     // not reserved
            Candera::KeyboardKeyCode::Key_None,     // not reserved
            Candera::KeyboardKeyCode::Key_None,     // not reserved
            Candera::KeyboardKeyCode::Key_None,     // not reserved
            Candera::KeyboardKeyCode::Key_Enter,
            Candera::KeyboardKeyCode::Key_Control,
            Candera::KeyboardKeyCode::Key_OEM2,
            Candera::KeyboardKeyCode::Key_Print,
            Candera::KeyboardKeyCode::Key_Alt,
            Candera::KeyboardKeyCode::Key_None,     // not reserved
            Candera::KeyboardKeyCode::Key_Home,
            Candera::KeyboardKeyCode::Key_UpArrow,
            Candera::KeyboardKeyCode::Key_PageUp,
            Candera::KeyboardKeyCode::Key_LeftArrow,
            Candera::KeyboardKeyCode::Key_RightArrow,
            Candera::KeyboardKeyCode::Key_End,
            Candera::KeyboardKeyCode::Key_DownArrow,
            Candera::KeyboardKeyCode::Key_PageDown,
            Candera::KeyboardKeyCode::Key_Insert,
            Candera::KeyboardKeyCode::Key_Del,
            Candera::KeyboardKeyCode::Key_None,     // not reserved
            Candera::KeyboardKeyCode::Key_None,     // not reserved
            Candera::KeyboardKeyCode::Key_None,     // not reserved
            Candera::KeyboardKeyCode::Key_None,     // not reserved
            Candera::KeyboardKeyCode::Key_None,     // not reserved
            Candera::KeyboardKeyCode::Key_None,     // not reserved
            Candera::KeyboardKeyCode::Key_None,     // not reserved
            Candera::KeyboardKeyCode::Key_Pause } };
        return waylandKeyInputToKeyCode;
    }

    Candera::KeyboardKeyCode::Enum KeyEvent::WaylandKeyCodeToKeyboardKeyCode(FeatStd::UInt16 index)
    {
        FEATSTD_UNSYNCED_STATIC_OBJECT(KeyCodeWaylandArray, keyCodeWaylandArray, GetKeyCodeWaylandArray());
        return keyCodeWaylandArray.waylandKeyInputToKeyCode[index];
    }
}


