//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################



#ifndef CANDERA_BEHAVIOR_TUNNEL_EVENT_DISPATCH_STRATEGY_H
#define CANDERA_BEHAVIOR_TUNNEL_EVENT_DISPATCH_STRATEGY_H

#include <CanderaBehavior/BehaviorBase/EventDispatchStrategy.h>

namespace Candera {
/** @addtogroup BehaviorBase
  * @{
  */

    /**
     * @brief: Tunnel strategy: the event will be dispatched from the root to the node until the dispatching it is stopped 
     * by a StopAfterDirectDispatching DispatchAction. For each node in this chain the Direct dispatch strategy is used.
     */
    class TunnelEventDispatchStrategy : public EventDispatchStrategy
    {
    public:
        /**
         * Dispatch the event starting at the topmost parent node traversing down to the given node
         * @param node The node at whose topmost parent node traversing is started.
         * @param event
         * @param dispatchResult
         * @param condition
         */
        static void TunnelDispatchEvent(const AbstractNodePointer& node, const FeatStd::Event& event, EventDispatchResult& dispatchResult, const Condition* condition = 0);

        /**
         * Calls TunnelEventDispatchStrategy::TunnelDispatchEvent to dispatch the event starting at the topmost parent node traversing down to the given node
         * @param node The node at whose topmost parent node traversing is started.
         * @param event
         * @param dispatchResult
         * @param condition
         */
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Default argument on virtual function matches the base-class argument it overrides. (See EventDispatchStrategy.h)")
        virtual void DispatchEvent(const AbstractNodePointer& node, const FeatStd::Event& event, EventDispatchResult& dispatchResult, const Condition* condition = 0);
    };
/** @} */
}

#endif
