//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "TunnelEventDispatchStrategy.h" 
#include <CanderaBehavior/BehaviorBase/DirectEventDispatchStrategy.h>

namespace Candera {

    void TunnelEventDispatchStrategy::TunnelDispatchEvent(const AbstractNodePointer& node, const FeatStd::Event& event, EventDispatchResult& dispatchResult, const Condition* condition)
    {
        FeatStd::Internal::Vector<AbstractNodePointer> stack;

        AbstractNodePointer current = node;
        while (current.IsValid()) {
            static_cast<void>(stack.Add(current));
            current = current.GetParent();
        }
        for (FeatStd::SizeType i = stack.Size(); (!dispatchResult.HasToStopAfterDirectDispatching()) && (!dispatchResult.HasToStopDispatchingImmediately()) && (i > 0); --i) {
            DirectEventDispatchStrategy::DirectDispatchEvent(stack[i - 1], event, dispatchResult, condition);
        }
    }

    void TunnelEventDispatchStrategy::DispatchEvent(const AbstractNodePointer& node, const FeatStd::Event& event, EventDispatchResult& dispatchResult, const Condition* condition)
    {
        TunnelDispatchEvent(node, event, dispatchResult, condition);
    }
}
