//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "TriggerBehavior.h"

namespace Candera {
    FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaBehavior);

    CGI_BEHAVIOR_RTTI_DEFINITION(TriggerBehavior)

    void TriggerBehavior::SetCondition(const ConditionType& condition)
    {
        if (m_Condition != condition) {
            m_Condition = condition;
            WakeUpAllRenderComponents();
        }
    }

#if defined(CANDERA_LEGACY_BEHAVIORS_ENABLED)
    void TriggerBehavior::SetAction(const ActionType& action)
    {
        if (m_Action != action) {
            m_Action = action;
            m_Actions.Clear();
            m_Actions.Add(m_Action);
            WakeUpAllRenderComponents();
        }
    }
#else
    void TriggerBehavior::SetActions(const ActionsType& actions)
    {
        if (m_Actions != actions) {
            m_Actions = actions;
            WakeUpAllRenderComponents();
        }
    }
#endif

    void TriggerBehavior::SetConsumeEvent(ConsumeEventType consumeEvent)
    {
        if (m_consumeEvent != consumeEvent) {
            m_consumeEvent = consumeEvent;
            WakeUpAllRenderComponents();
        }
    }

#ifdef FEATSTD_LOG_ENABLED
    static const Char* SafeLogString(const Char* s)
    {
        return (0 == s) ? "" : s;
    }
#endif

    void TriggerBehavior::OnEvent(const FeatStd::Event& event, EventDispatchResult& dispatchResult)
    {
        if ((0 != GetCondition()) && (0 != GetActions().GetCount())) {
            ConditionEvaluationResult conditionEvaluationResult;
            EvaluateConditionEvent evaluateConditionEvent(event, this);
            GetCondition()->DispatchEventLocal(evaluateConditionEvent, conditionEvaluationResult);
            if (conditionEvaluationResult.IsMatch()) {
                FEATSTD_LOG_DEBUG("TriggerBehavior '%s' on node '%s' with condition '%s' and event '%s'%s: begin invoking actions!", SafeLogString(GetName()), SafeLogString(GetNode().GetName()), SafeLogString(GetCondition()->GetName()), event.GetDynamicTypeId(), GetConsumeEvent() ? " (event consumed)" : "");
                ActionBehavior::Invoke(this, &event, GetActions());
                FEATSTD_LOG_DEBUG("TriggerBehavior '%s' on node '%s' with condition '%s' and event '%s'%s: finished invoking actions!", SafeLogString(GetName()), SafeLogString(GetNode().GetName()), SafeLogString(GetCondition()->GetName()), event.GetDynamicTypeId(), GetConsumeEvent() ? " (event consumed)" : "");
                if (GetConsumeEvent()) {
                    dispatchResult.SetHandled();
                    dispatchResult.StopDispatchingImmediately();
                }
            }
            else {
                FEATSTD_LOG_DEBUG("TriggerBehavior '%s' on node '%s' with condition '%s' and event '%s': no match!", SafeLogString(GetName()), SafeLogString(GetNode().GetName()), SafeLogString(GetCondition()->GetName()), event.GetDynamicTypeId());
            }
        }
    }
}
