//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "EventDispatchStrategy.h"
#include <CanderaBehavior/BehaviorBase/Behavior.h>

namespace Candera {

    bool EventDispatchStrategy::IsDirectEventReceiver(const Behavior* behavior)
    {
        if (0 != behavior) {
            return behavior->IsDirectEventReceiver();
        }
        return false;
    }

    void EventDispatchStrategy::OnEvent(Behavior* behavior, const FeatStd::Event& event, EventDispatchResult& dispatchResult)
    {
        if (0 != behavior) {
            behavior->OnEvent(event, dispatchResult);
        }
    }

    void EventDispatchStrategy::ResetStopDispatchingImmediately(EventDispatchResult& dispatchResult)
    {
        dispatchResult.ResetStopDispatchingImmediately();
    }

    void EventDispatchStrategy::ResetStopDirectDispatching(EventDispatchResult& dispatchResult)
    {
        dispatchResult.ResetStopDirectDispatching();
    }

    void EventDispatchStrategy::ResetStopAfterDirectDispatching(EventDispatchResult& dispatchResult)
    {
        dispatchResult.ResetStopAfterDirectDispatching();
    }

    void EventDispatchStrategy::ResetStopDispatchingForDescendants(EventDispatchResult& dispatchResult)
    {
        dispatchResult.ResetStopDispatchingForDescendants();
    }

    void EventDispatchStrategy::ResetStopDispatchingForSiblings(EventDispatchResult& dispatchResult)
    {
        dispatchResult.ResetStopDispatchingForSiblings();
    }

}
