//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_BEHAVIOR_EVENT_DISPATCH_RESULT_H
#define CANDERA_BEHAVIOR_EVENT_DISPATCH_RESULT_H

#include <FeatStd/Util/Rtti.h>


namespace Candera {
/** @addtogroup BehaviorBase
  * @{
  */

    class EventDispatchResult
    {
    public:
        FEATSTD_RTTI_DECLARATION();

        /**
         * EventDispatchResult default constructor.
         */
        EventDispatchResult();

        /**
         * Sets the EventDispatchResult to the given value (handled or not handled).
         * @param value True if the result should be set to handled, false otherwise.
         */
        void SetHandled(bool value = true) { m_handled = value; }

        /**
         * Check if the EventDispatchResult has been handled.
         * @return True if the result has been handled, false otherwise.
         */
        bool IsHandled() const { return m_handled; }

        /**
         * Sets the flag for stopping dispatching immediately to true.
         */
        void StopDispatchingImmediately() { m_stopDispatchingImmediately = true; }

        /**
         * Sets the flag for stopping dispatching to true.
         */
        void StopDirectDispatching() { m_stopDirectDispatching = true; }

        /**
         * Sets the flag for stopping dispatching after direct dispatching to true.
         */
        void StopAfterDirectDispatching() { m_stopAfterDirectDispatching = true; }

        /**
         * Sets the flag for stopping dispatching for descendants to true.
         */
        void StopDispatchingForDescendants() { m_stopDispatchingForDescendants = true; }

        /**
         * Sets the flag for stopping dispatching for siblings to true.
         */
        void StopDispatchingForSiblings() { m_stopDispatchingForSiblings = true; }

        //TODO: StopDispatchingAfterSiblings

        /**
         * Checks the flag for stopping dispatching immediately.
         * @return True if dispatching has to be stopped immediately.
         */
        bool HasToStopDispatchingImmediately() const { return m_stopDispatchingImmediately; }

        /**
         * Checks the flag for stopping dispatching.
         * @return True if dispatching has to be stopped.
         */
        bool HasToStopDirectDispatching() const { return m_stopDirectDispatching; }

        /**
         * Checks the flag for stopping dispatching after direct dispatching.
         * @return True if dispatching has to be stopped after direct dispatching.
         */
        bool HasToStopAfterDirectDispatching() const { return m_stopAfterDirectDispatching; }

        /**
         * Checks the flag for stopping dispatching for descendants.
         * @return True if dispatching for descendants has to be stopped.
         */
        bool HasToStopDispatchingForDescendants() const { return m_stopDispatchingForDescendants; }

        /**
         * Checks the flag for stopping dispatching for siblings.
         * @return True if dispatching for siblings has to be stopped.
         */
        bool HasToStopDispatchingForSiblings() const { return m_stopDispatchingForSiblings; }

        /**
         * Checks the flag for stopping posting messages.
         * @return True if message posting has to be stopped.
         */
        bool HasToStopPostMessage() const { return m_stopPostMessage; }

    private:
        friend class EventDispatchStrategy;

        void ResetStopDispatchingImmediately() { m_stopDispatchingImmediately = false; }

        void ResetStopDirectDispatching() { m_stopDirectDispatching = false; }

        void ResetStopAfterDirectDispatching() { m_stopAfterDirectDispatching = false; }

        void ResetStopDispatchingForDescendants() { m_stopDispatchingForDescendants = false; }

        void ResetStopDispatchingForSiblings() { m_stopDispatchingForSiblings = false; }

        bool m_handled;
        bool m_stopDispatchingImmediately;
        bool m_stopDirectDispatching;
        bool m_stopAfterDirectDispatching;
        bool m_stopDispatchingForDescendants;
        bool m_stopDispatchingForSiblings;
        bool m_stopPostMessage;
    };
/** @} */
}

#endif
