//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "BroadcastEventDispatchStrategy.h"

#include <CanderaBehavior/BehaviorBase/DirectEventDispatchStrategy.h>
#include <FeatStd/Util/StaticObject.h>

namespace Candera {

    BroadcastEventDispatchStrategy& BroadcastEventDispatchStrategy::GetInstance()
    {
        FEATSTD_SYNCED_STATIC_OBJECT(BroadcastEventDispatchStrategy, s_broadcastEventDispatchStrategy);
        return s_broadcastEventDispatchStrategy;
    }

    void BroadcastEventDispatchStrategy::BroadcastDispatchEvent(const AbstractNodePointer& node, const FeatStd::Event& event, EventDispatchResult& dispatchResult, const Condition* condition)
    {
        AbstractNodePointer current = node;
        while ((!dispatchResult.HasToStopAfterDirectDispatching()) && (!dispatchResult.HasToStopDispatchingImmediately()) && current.IsValid()) {
            DirectEventDispatchStrategy::DirectDispatchEvent(current, event, dispatchResult, condition);
            AbstractNodePointer firstChild;
            if (!dispatchResult.HasToStopDispatchingForDescendants()) {
                firstChild = current.GetFirstChild();
            }
            else {
                ResetStopDispatchingForDescendants(dispatchResult);
            }
            if (firstChild.IsValid()) {
                current = firstChild;
            }
            else {
                if (current == node) {
                    current = AbstractNodePointer();
                }
                else {
                    AbstractNodePointer nextSibling;
                    if (!dispatchResult.HasToStopDispatchingForSiblings()) {
                        nextSibling = current.GetNextSibling();
                    }
                    else {
                        ResetStopDispatchingForSiblings(dispatchResult);
                    }
                    if (nextSibling.IsValid()) {
                        current = nextSibling;
                    }
                    else {
                        while (current.IsValid() && (!nextSibling.IsValid())) {
                            current = current.GetParent();
                            if (current == node) {
                                current = AbstractNodePointer();
                            }
                            else {
                                nextSibling = current.GetNextSibling();
                            }
                        }
                        current = nextSibling;
                    }
                }
            }
        }
    }

    void BroadcastEventDispatchStrategy::DispatchEvent(const AbstractNodePointer& node, const FeatStd::Event& event, EventDispatchResult& dispatchResult, const Condition* condition)
    {
        BroadcastDispatchEvent(node, event, dispatchResult, condition);
    }

}
