//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#ifndef CANDERA_BEHAVIOR_EVENT_HUB_H
#define CANDERA_BEHAVIOR_EVENT_HUB_H

#include <FeatStd/Event/EventListener.h>
#include <Candera/EngineBase/Common/AbstractNodePointer.h>
#include <CanderaBehavior/BehaviorBase/BroadcastEventDispatchStrategy.h>

namespace Candera {
/** @addtogroup BehaviorBase
  * @{
  */

    /**
     * @note The BehaviorEventHub is not thread save. It is intended to distribute events from event sources that are located in the same thread.
     */
    class BehaviorEventHub : public FeatStd::EventListener
    {
    public:
        /**
         * BehaviorEventHub default constructor
         */
        BehaviorEventHub();
        
        /**
         * BehaviorEventHub constructor
         * @param dispatchStrategy 
         */
        BehaviorEventHub(EventDispatchStrategy& dispatchStrategy);

        /**
         * retrieves the BehaviorEventHub's nodes
         * @return the BehaviorEventHub's nodes
         */
        FeatStd::Internal::Vector<AbstractNodePointer>& Nodes();

    protected:
        /**
         * Event handling method implementation with mechanisms to route events to other behaviors.
         * @param event The \event to handle.
         * @return The result.
         */
        virtual FeatStd::EventResult::Enum OnEvent(const FeatStd::Event& event);

    private:
        FEATSTD_MAKE_CLASS_UNCOPYABLE(BehaviorEventHub);
        FeatStd::Internal::Vector<AbstractNodePointer> m_nodes;
        EventDispatchStrategy& m_dispatchStrategy;
    };

/** @} */
#endif //CANDERA_BEHAVIOR_EVENT_HUB_H
}
