//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "BehaviorEventHub.h"

namespace Candera {

    BehaviorEventHub::BehaviorEventHub() :
        m_dispatchStrategy(BroadcastEventDispatchStrategy::GetInstance())
    {
    }

    BehaviorEventHub::BehaviorEventHub(EventDispatchStrategy& dispatchStrategy) :
        m_dispatchStrategy(dispatchStrategy)
    {
    }

    FeatStd::Internal::Vector<AbstractNodePointer>& BehaviorEventHub::Nodes() {
        return m_nodes;
    }

    FeatStd::EventResult::Enum BehaviorEventHub::OnEvent(const FeatStd::Event& event)
    {
        for (FeatStd::SizeType i = 0; i < m_nodes.Size(); ++i) {
            EventDispatchResult eventDispatchResult;
            m_dispatchStrategy.DispatchEvent(m_nodes[i], event, eventDispatchResult);
            if (eventDispatchResult.HasToStopAfterDirectDispatching() || eventDispatchResult.HasToStopDispatchingImmediately()) {
                //TOOD: Check if Proceed is the way to go.
                return FeatStd::EventResult::Proceed;
            }
        }

        //TOOD: Check if Proceed is the way to go.
        return FeatStd::EventResult::Proceed;
    }
}
