//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_THEME_H)
#define CANDERA_THEME_H

#include <Candera/Environment.h>
#include <CanderaAssetLoader/AssetLoaderBase/ObjectMap.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetId.h>
#include <Candera/System/Container/Map.h>

namespace Candera {
    class ThemeEntriesCollection;

    namespace Internal {
        class BinaryTheme {
        public:
            typedef Map<Id, AssetId> AssetIdEntryCollection;
            typedef Map<Id, AssetIdEntryCollection> EntryCollections;

            AssetIdEntryCollection* GetAssetIdEntryCollection(Id collectionId);
        private:

            EntryCollections m_collections;
        };
    }

    class Theme {
        public:
            static Theme* Create(bool copyCollectionsNames = false) { return ASSETLOADER_TRANSIENT_NEW(Theme)(copyCollectionsNames); }
            void Dispose();
            ~Theme();

            static void SetMasterTheme(Theme* master) { MasterTheme() = master; }
            bool IsMaster() const { return (MasterTheme() == this); }

            ThemeEntriesCollection* CreateCollection(const Char* name);
            ThemeEntriesCollection* GetCollectionByName(const Char* name);

        private:
            CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704,Candera::Theme::Theme, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
            FEATSTD_MAKE_CLASS_STATIC(Theme);
            FEATSTD_MAKE_CLASS_UNCOPYABLE(Theme);
            Theme(bool copyCollectionsNames);

            static Theme*& MasterTheme();
            bool m_isMaster;
            Internal::ObjectMap<ThemeEntriesCollection*> m_collections;
    };
}

#endif //CANDERA_THEME_H
