//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Theme.h"
#include <CanderaAssetLoader/AssetLoaderBase/ThemeEntriesCollection.h>

namespace Candera {
    namespace Internal {
        BinaryTheme::AssetIdEntryCollection* BinaryTheme::GetAssetIdEntryCollection(Id collectionId)
        {
            AssetIdEntryCollection* result = m_collections.Find(collectionId);
            if (result == 0) {
                if (!m_collections.Insert(collectionId, AssetIdEntryCollection())) {
                    return 0;                
                }
                result = m_collections.Find(collectionId);
            }
            
            return result;
        }
    }

    Theme::Theme(bool copyCollectionsNames) :
        m_isMaster(false),
        m_collections(copyCollectionsNames)
    {
    }

    Theme::~Theme()
    {
        for (Internal::ObjectMap<ThemeEntriesCollection*>::MapIterator it = m_collections.Begin(); m_collections.IsIteratorValid(it); it = m_collections.Remove(it)) {
            it->GetValue()->Dispose();
        }
    }

    void Theme::Dispose()
    {
        FEATSTD_DELETE(this);
    }

    ThemeEntriesCollection* Theme::CreateCollection(const Char* name)
    {
        if (GetCollectionByName(name) != 0) {
            return 0;
        }

        ThemeEntriesCollection* newThemeEntriesCollection = ThemeEntriesCollection::Create();
        m_collections[name] = newThemeEntriesCollection;
        return newThemeEntriesCollection;
    }

    ThemeEntriesCollection* Theme::GetCollectionByName(const Char* name)
    {
        Internal::ObjectMap<ThemeEntriesCollection*>::MapIterator it = m_collections.Find(name);
        if (m_collections.IsIteratorValid(it)) {
            return it->GetValue();
        }

        return 0;
    }

    Theme*& Theme::MasterTheme()
    {
        static Theme* masterTheme = 0;
        return masterTheme;
    }}
