//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if  !defined(CANDERA_STATEMACHINEBEHAVIORDATA_H)
#define CANDERA_STATEMACHINEBEHAVIORDATA_H

#include <Candera/Environment.h>

#include <FeatStd/Container/Vector.h>
#include <FeatStd/Util/StateMachine2.h>
#include <FeatStd/Util/Optional.h>

namespace FeatStd {
    class Event;
}

namespace Candera {

    class StateMachineBehavior;
    class ConditionBehavior;
    class ActionBehavior;

    namespace Internal {
         
        class StateMachineBehaviorData;
        class StateMachineBehaviorBuilder;
        template <typename T> class AssetReaderBase; 

        typedef FeatStd::Event StateMachineBehaviorEvent;
        typedef StateMachineBehavior StateMachineBehaviorContext;

        class StateMachineBehaviorConditionEvaluation
        {
        public:
            StateMachineBehaviorConditionEvaluation();
            StateMachineBehaviorConditionEvaluation(ConditionBehavior* condition);
            StateMachineBehaviorConditionEvaluation(const StateMachineBehaviorConditionEvaluation& conditionEvaluation);
            StateMachineBehaviorConditionEvaluation& operator=(const StateMachineBehaviorConditionEvaluation& conditionEvaluation);
            bool operator!() const;
            const StateMachineBehaviorConditionEvaluation& operator*() const;
            bool operator()(const StateMachineBehaviorEvent& event, const StateMachineBehaviorContext& dataContext, const FeatStd::Internal::TransitionBase& transition) const;

        private:
            ConditionBehavior* m_condition;
        };

        class StateMachineBehaviorActionCall
        {
        public:
            StateMachineBehaviorActionCall(StateMachineBehaviorData& stateMachineBehavior, FeatStd::SizeType begin, FeatStd::SizeType end);
            StateMachineBehaviorActionCall(const StateMachineBehaviorActionCall& actionCall);
            bool operator!() const;
            const StateMachineBehaviorActionCall& operator*() const;
            void operator()(StateMachineBehavior& dataContext) const;

        private:
            StateMachineBehaviorData& m_stateMachine;
            FeatStd::SizeType m_begin;
            FeatStd::SizeType m_end;
            StateMachineBehaviorActionCall& operator=(const StateMachineBehaviorActionCall& actionCall);
        };

        class StateMachineBehaviorData
        {
        public:
            ~StateMachineBehaviorData();

            static StateMachineBehaviorData* Create();
            void Dispose();

        private:
            StateMachineBehaviorData();

            friend class ::Candera::StateMachineBehavior;
            friend class StateMachineBehaviorActionCall;
            template <typename T> friend class AssetReaderBase;
            template <typename T> friend class AssetBuilderBase;
            friend class StateMachineBehaviorBuilder;

            typedef FeatStd::Internal::HistoryStateMachine<StateMachineBehaviorEvent, StateMachineBehaviorContext, StateMachineBehaviorActionCall, StateMachineBehaviorConditionEvaluation> HistoryStateMachine;
            typedef HistoryStateMachine::StateMachineType StateMachine;
            typedef StateMachine::StateType State;
            typedef State::Transition Transition;

            FeatStd::Internal::Vector<Candera::ConditionBehavior*> m_conditions;
            FeatStd::Internal::Vector<Candera::ActionBehavior*> m_actions;
            FeatStd::Internal::Vector<State*> m_states;
            FeatStd::Internal::Vector<Transition*> m_transitions;
            FeatStd::Initialized<bool> m_initialized;

            FEATSTD_MAKE_CLASS_UNCOPYABLE(StateMachineBehaviorData);
        };
    }
}

#endif //CANDERA_STATEMACHINEBEHAVIORDATA_H  
