//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "StateMachineData.h"

#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/StateMachineAssetBuilder.h>

#include <CanderaBehavior/BehaviorBase/StateMachineBehavior.h>
#include <CanderaBehavior/BehaviorBase/ConditionBehavior.h>
#include <CanderaBehavior/BehaviorBase/ActionBehavior.h>

namespace Candera {
    namespace Internal {

        StateMachineBehaviorActionCall::StateMachineBehaviorActionCall(StateMachineBehaviorData& stateMachineBehavior, FeatStd::SizeType begin, FeatStd::SizeType end):
            m_stateMachine(stateMachineBehavior),
            m_begin(begin),
            m_end(end)
        {
        }

        StateMachineBehaviorActionCall::StateMachineBehaviorActionCall(const StateMachineBehaviorActionCall& actionCall):
            m_stateMachine(actionCall.m_stateMachine),
            m_begin(actionCall.m_begin),
            m_end(actionCall.m_end)
        {
        }

        bool StateMachineBehaviorActionCall::operator!() const
        {
            return m_begin >= m_end;
        }

        const StateMachineBehaviorActionCall& StateMachineBehaviorActionCall::operator*() const
        {
            return *this;
        }

        void StateMachineBehaviorActionCall::operator()(StateMachineBehavior& dataContext) const
        {
            ActionBehavior::Invoke(&dataContext, 0, m_stateMachine.m_actions, m_begin, m_end);
        }

        StateMachineBehaviorConditionEvaluation::StateMachineBehaviorConditionEvaluation():
            m_condition(0)
        {
        }

        StateMachineBehaviorConditionEvaluation::StateMachineBehaviorConditionEvaluation(ConditionBehavior* condition) :
            m_condition(condition)
        {
        }

        StateMachineBehaviorConditionEvaluation::StateMachineBehaviorConditionEvaluation(const StateMachineBehaviorConditionEvaluation& conditionEvaluation) :
            m_condition(conditionEvaluation.m_condition)
        {
        }

        StateMachineBehaviorConditionEvaluation& StateMachineBehaviorConditionEvaluation::operator=(const StateMachineBehaviorConditionEvaluation& conditionEvaluation)
        {
            CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(1555, "Intended copy of pointer.")
                m_condition = conditionEvaluation.m_condition;
            return *this;
        }

        bool StateMachineBehaviorConditionEvaluation::operator!() const
        {
            return (0 == m_condition);
        }

        const StateMachineBehaviorConditionEvaluation& StateMachineBehaviorConditionEvaluation::operator*() const
        {
            return *this;
        }


        bool StateMachineBehaviorConditionEvaluation::operator()(const StateMachineBehaviorEvent& event, const StateMachineBehaviorContext& dataContext, const FeatStd::Internal::TransitionBase& /*transition*/) const
        {
            if (0 != m_condition) {
                ConditionEvaluationResult conditionEvaluationResult;
                EvaluateConditionEvent evaluateConditionEvent(event, &dataContext);
                m_condition->DispatchEventLocal(evaluateConditionEvent, conditionEvaluationResult);
                return conditionEvaluationResult.IsMatch();
            }
            return false;
        }

        StateMachineBehaviorData* StateMachineBehaviorData::Create()
        {
            return FEATSTD_NEW(StateMachineBehaviorData);
        }

        void StateMachineBehaviorData::Dispose()
        {
            AssetBuilder<StateMachineBehaviorData*>::Dispose(this);
            FEATSTD_DELETE(this);
        }

        StateMachineBehaviorData::StateMachineBehaviorData()
        {
        }

        StateMachineBehaviorData::~StateMachineBehaviorData()
        {
        }
    }
}
