//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_PROPERTYDEFINITION_H)
#define CANDERA_PROPERTYDEFINITION_H

#include <Candera/Environment.h>

namespace Candera {
    namespace Internal {

        class PropertyDefinition
        {
        public:
            /** 
             * Constructor associating name, widgetPath and widgetPropertyName to a PropertyDefinition.
             * Specified strings have external lifetime.
             * @param name               Name of this PropertyDefinition.
             * @param widgetPath         Path of widget this property definition is associated.
             * @param widgetPropertyName Name of widget property on which this property definition is made.
             */
            PropertyDefinition(const Char* name, const Char* widgetPath, const Char* widgetPropertyName);

            /**
             * Constructor associating other PropertyDefinition.
             * @param other The other PropertyDefinition.
             */
            PropertyDefinition(const PropertyDefinition& other);

            /**
             * Destrucor
             */
            ~PropertyDefinition(void);

            PropertyDefinition& operator=(const PropertyDefinition& other);

            /**
             * Retrieves the definition property name
             * @return The definition property name
             */
            inline const Char* GetName() const { return m_name; }
    
            /**
             * Returns the widget name to which this definition is associated
             * @return The widget name to which this definition is associated
             */
            inline const Char* GetWidgetPath() const { return m_widgetPath; } 
    
            /**
             * Returns the widget property name on which the definition is made
             * @return The widget property name on which the definition is made
             */
            inline const Char* GetWidgetPropertyname() const { return m_widgetPropertyName; } 

        private:
            const Char* m_name;
            const Char* m_widgetPath;
            const Char* m_widgetPropertyName;
        };
    }
}

#endif //CANDERA_PROPERTYDEFINITION_H
