//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_TypedAssetProviderBase_H)
    #define CANDERA_TypedAssetProviderBase_H

#include <Candera/Environment.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetId.h>

namespace Candera {
    class DefaultAssetProvider;
    namespace Internal {
        /**
        *  Base class without template parameters for TypedAssetProvider to allow implementation of method
        *  GetProvider() in cpp file.
        */

        class TypedAssetProviderBase {
            public:
                Candera::DefaultAssetProvider& GetProvider() const;

                /**
                 * Release an object.
                 *
                 * Releasing and deleting objects from the AssetProvider should be done with care since there is a possibility
                 *  that other cached objects store pointers to released objects.
                 *
                 * @param name Name of the object.
                 */
                virtual void Release(AssetId id, bool dispose) = 0;
        };
    }
}   // namespace Candera

#endif  // CANDERA_TypedAssetProviderBase_H
