//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_FILEASSETREPOSITORY_H)
#define CANDERA_FILEASSETREPOSITORY_H

#include <CanderaPlatform/OS/FilePlatform.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetRepository.h>

namespace Candera {

/** @addtogroup AssetLoaderBase
 *  @{
 */
 
    /**
     * @brief Class providing methods to read asset from file
     */
    class FileAssetRepository : public AssetRepository
    {
    public:

        /**
         * Constructor
         * @param fileName The path and name of the asset file
         */
        FileAssetRepository(const Char* fileName);

        /**
         * Destructor
         */
        virtual ~FileAssetRepository(void);

        /**
         * Initializes the repository so it's ready for read
         * @return true if successful
         */
        virtual bool Initialize();
        
        /**  
         * Reads from the asset repository and copies output in buffer. Position indicator (AssetTell) is
         * advanced by the total amount of bytes read.
         * @param buffer Pointer to a pre allocated buffer to copy the read values into.
         * @param elementSize Size of one element to read, in bytes.
         * @param count         Count of elements to read.
         * @return              Amount of bytes read .
         */
        virtual SizeType AssetRead(void* buffer, SizeType elementSize, SizeType count);
        /**
         * Seeks a position in the asset by offset bytes
         * @param offset Number of offset to look and set position indicator (AssetTell) to.
         * @param mark   Whether offset is begin of stream or current position in stream.
         * @return       True if successful.
         */
        virtual bool AssetSeek(OffsetType offset, AssetSeekMark mark);
        
        /**
        * Returns the current asset repository position
        * @return The current asset repository position.
        */
        virtual OffsetType AssetTell();

        /**
         * Finalizes the repository.
         * @return true if successful
         */
        virtual bool Finalize();

    private:
        Char* m_fileName;
        FileHandle m_currentFile;        
    };
 
 /** @} */ // end of AssetLoaderBase
 
}

#endif // CANDERA_FILEASSETREPOSITORY_H
