//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "FileAssetRepository.h"
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <CanderaPlatform/OS/StringPlatform.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetLoaderMemoryPool.h>

namespace Candera {
    FileAssetRepository::FileAssetRepository(const Char* fileName) :
        m_fileName(0),
        m_currentFile(0)
    {
        m_fileName = ASSETLOADER_TRANSIENT_NEW_ARRAY(Char, StringPlatform::Length(fileName) + 1);
        if (m_fileName != 0) {
            StringPlatform::Copy(m_fileName, fileName);
        }
    }

    FileAssetRepository::~FileAssetRepository()
    {
        // m_currentFile is zeroed by Finalize()
        CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1740, Candera::FileAssetRepository::m_currentFile, CANDERA_LINT_REASON_ASSOCIATION)

            ASSETLOADER_DELETE_ARRAY(m_fileName);
        m_fileName = 0;
    }

    bool FileAssetRepository::Initialize() {
        if (m_fileName == 0) {
            return false;
        }
        m_currentFile = FilePlatform::Open(m_fileName);
        return FilePlatform::IsFileOpened(m_currentFile);
    }

    SizeType FileAssetRepository::AssetRead(void* buffer, SizeType elementSize, SizeType count) {
        return static_cast<Int32>(FilePlatform::Read(m_currentFile, buffer, static_cast<Int32>(elementSize), static_cast<Int32>(count)));
    }

    bool FileAssetRepository::AssetSeek(OffsetType offset, AssetSeekMark mark) {
        return FilePlatform::Seek(m_currentFile, offset, static_cast<FilePlatform::SeekMark>(mark));
    }

    OffsetType FileAssetRepository::AssetTell() {
        return FilePlatform::Tell(m_currentFile);
    }
    
    bool FileAssetRepository::Finalize() {
        bool result = true;
        if (m_currentFile != 0) {
            if (FilePlatform::IsFileOpened(m_currentFile)) {
                result = FilePlatform::Close(m_currentFile);
            } else {
                result = false;
            }
            m_currentFile = 0;
        }

        return result;
    }
} //namespace Candera

