//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DynamicAssetConfig.h"

namespace Candera {

    AssetRepository* DynamicAssetConfig::GetAssetRepository(UInt16 index) const
    {
        return (m_repositoryList.Size() > index) ? m_repositoryList[index] : 0;
    }

    UInt16 DynamicAssetConfig::GetAssetRepositoryCount() const
    {
        return static_cast<UInt16>(m_repositoryList.Size());
    }

    void DynamicAssetConfig::AddRepository(AssetRepository* assetRepository)
    {
        static_cast<void>(m_repositoryList.Add(assetRepository));
        OnAssetRepositoryAdded(assetRepository);
    }

    void DynamicAssetConfig::RemoveRepository(AssetRepository* assetRepository)
    {
        for (SizeType i = 0; i < m_repositoryList.Size(); i++) {
            if (m_repositoryList[i] == assetRepository) {
                static_cast<void>(m_repositoryList.Remove(i));
                OnAssetRepositoryRemoved(assetRepository);
                break;
            }
        }
    }

}   // namespace Candera
