//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DefaultResourceProvider_H)
#define CANDERA_DefaultResourceProvider_H

#include <FeatStd/MemoryManagement/SharedPointer.h>
#include <Candera/EngineBase/Common/ResourceDataHandle.h>
#include <Candera/EngineBase/Common/ResourceProvider.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetId.h>

namespace Candera {

    class DefaultAssetProvider; 
    namespace Internal {
        class AssetGroup;
        
        class DefaultResourceProvider: public ResourceProvider {
            friend class Candera::DefaultAssetProvider;
            public:

            ResourceDataHandle CreateRegionDataHandle(AssetLib libType, Id id, UInt16 regionId, UInt32 size);
            
            virtual const void* Lock(const ResourceDataHandle& resourceDataHandle, bool& isPersistent) final override;
            virtual void Retain(const void* data) final override;
            virtual void Release(const void* data) final override;
            virtual SizeType ReadData(void* buffer, const ResourceDataHandle& handle, SizeType offset, SizeType count) final override;

            static DefaultResourceProvider& GetResourceProviderInstance();
            private:
            FeatStd::MemoryManagement::SharedPointer<AssetGroup> m_assetGroup;
        };
    }   // namespace Internal
}   // namespace Candera

#endif // CANDERA_DefaultResourceProvider_H
