//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DEFAULT_ASSET_CONFIG_H)
    #define CANDERA_DEFAULT_ASSET_CONFIG_H

#include <CanderaAssetLoader/AssetLoaderBase/AssetConfig.h>

namespace Candera {

    /** @addtogroup AssetLoaderBase
     *  @{
     */

    /**
     *  @brief  DefaultAssetConfig is used for static asset configurations.
     */
    class DefaultAssetConfig : public AssetConfig {

    public:
        /**
         *  Constructor
         */
        DefaultAssetConfig();

        /**
         *  Destructor
         */
        virtual ~DefaultAssetConfig();

        /**
         *  Initialize the Configuration
         *  @param assetRepositories The asset repositories that are set
         *  @param count The count that is set
         */
        void Initialize(AssetRepository** assetRepositories, UInt16 count);

        /**
         *  Retrieve the asset repository at a given index.
         *  @param index The index of the asset repository.
         *  @return The AssetRepository if available, else 0
         */
        virtual AssetRepository* GetAssetRepository(UInt16 index) const;

        /**
         *  Retrieve the asset repository count.
         *  @return The asset repository count.
         */
        virtual UInt16 GetAssetRepositoryCount() const;

    protected:

    private:
        UInt16 m_count;
        AssetRepository** m_asssetRepositories;
    };

    /// @}

}   // namespace Candera

#endif  // CANDERA_DEFAULT_ASSET_CONFIG_H
