//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef VertexAttribute_CffReader_H
#define VertexAttribute_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for VertexAttribute
    static const Int32 CFF_VERTEX_ATTRIBUTE_OFFSET_OFFSET                                     = (0);
    static const Int32 CFF_VERTEX_ATTRIBUTE_TYPE_OFFSET                                       = (4 + CFF_VERTEX_ATTRIBUTE_OFFSET_OFFSET);
    static const Int32 CFF_VERTEX_ATTRIBUTE_ID_OFFSET                                         = (4 + CFF_VERTEX_ATTRIBUTE_TYPE_OFFSET);
    static const Int32 CFF_VERTEX_ATTRIBUTE_USAGE_INDEX_OFFSET                                = (4 + CFF_VERTEX_ATTRIBUTE_ID_OFFSET);
    static const Int32 CFF_VERTEX_ATTRIBUTE_SIZE                                              = (4 + CFF_VERTEX_ATTRIBUTE_USAGE_INDEX_OFFSET);

    // getter methods for VertexAttribute
    inline UInt16 GetVertexAttributeOffset(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt16>(handle, CFF_VERTEX_ATTRIBUTE_OFFSET_OFFSET);
    }
    inline Int32 GetVertexAttributeType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_VERTEX_ATTRIBUTE_TYPE_OFFSET);
    }
    inline Int32 GetVertexAttributeId(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_VERTEX_ATTRIBUTE_ID_OFFSET);
    }
    inline UInt8 GetVertexAttributeUsageIndex(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt8>(handle, CFF_VERTEX_ATTRIBUTE_USAGE_INDEX_OFFSET);
    }

}}} //namespaces

#endif //VertexAttribute_CffReader_H
