//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef UniformSetter_CffReader_H
#define UniformSetter_CffReader_H

#include "NodeAttachmentCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for UniformSetter
    static const Int32 CFF_UNIFORM_SETTER_IS_MODEL_MATRIX_4ENABLED_CFF_OFFSET                 = (CFF_NODE_ATTACHMENT_SIZE);
    static const Int32 CFF_UNIFORM_SETTER_IS_MODEL_MATRIX_3ENABLED_CFF_OFFSET                 = (4 + CFF_UNIFORM_SETTER_IS_MODEL_MATRIX_4ENABLED_CFF_OFFSET);
    static const Int32 CFF_UNIFORM_SETTER_IS_NORMAL_MODEL_MATRIX_3ENABLED_CFF_OFFSET          = (4 + CFF_UNIFORM_SETTER_IS_MODEL_MATRIX_3ENABLED_CFF_OFFSET);
    static const Int32 CFF_UNIFORM_SETTER_IS_MODEL_VIEW_MATRIX_4ENABLED_CFF_OFFSET            = (4 + CFF_UNIFORM_SETTER_IS_NORMAL_MODEL_MATRIX_3ENABLED_CFF_OFFSET);
    static const Int32 CFF_UNIFORM_SETTER_IS_MODEL_VIEW_MATRIX_3ENABLED_CFF_OFFSET            = (4 + CFF_UNIFORM_SETTER_IS_MODEL_VIEW_MATRIX_4ENABLED_CFF_OFFSET);
    static const Int32 CFF_UNIFORM_SETTER_IS_NORMAL_MODEL_VIEW_MATRIX_3ENABLED_CFF_OFFSET     = (4 + CFF_UNIFORM_SETTER_IS_MODEL_VIEW_MATRIX_3ENABLED_CFF_OFFSET);
    static const Int32 CFF_UNIFORM_SETTER_IS_PROJECTION_MATRIX_4ENABLED_CFF_OFFSET            = (4 + CFF_UNIFORM_SETTER_IS_NORMAL_MODEL_VIEW_MATRIX_3ENABLED_CFF_OFFSET);
    static const Int32 CFF_UNIFORM_SETTER_IS_MODEL_VIEW_PROJECTION_MATRIX_4ENABLED_CFF_OFFSET  = (4 + CFF_UNIFORM_SETTER_IS_PROJECTION_MATRIX_4ENABLED_CFF_OFFSET);
    static const Int32 CFF_UNIFORM_SETTER_IS_CAMERA_LOOK_AT_VECTOR_ENABLED_CFF_OFFSET         = (4 + CFF_UNIFORM_SETTER_IS_MODEL_VIEW_PROJECTION_MATRIX_4ENABLED_CFF_OFFSET);
    static const Int32 CFF_UNIFORM_SETTER_IS_CAMERA_POSITION_ENABLED_CFF_OFFSET               = (4 + CFF_UNIFORM_SETTER_IS_CAMERA_LOOK_AT_VECTOR_ENABLED_CFF_OFFSET);
    static const Int32 CFF_UNIFORM_SETTER_IS_LIGHTS_ACTIVATION_ENABLED_CFF_OFFSET             = (4 + CFF_UNIFORM_SETTER_IS_CAMERA_POSITION_ENABLED_CFF_OFFSET);
    static const Int32 CFF_UNIFORM_SETTER_IS_MATERIAL_ACTIVATION_ENABLED_CFF_OFFSET           = (4 + CFF_UNIFORM_SETTER_IS_LIGHTS_ACTIVATION_ENABLED_CFF_OFFSET);
    static const Int32 CFF_UNIFORM_SETTER_IS_TEXTURE_ACTIVATION_ENABLED_CFF_OFFSET            = (4 + CFF_UNIFORM_SETTER_IS_MATERIAL_ACTIVATION_ENABLED_CFF_OFFSET);
    static const Int32 CFF_UNIFORM_SETTER_LIGHT_COORDINATE_SPACE_OFFSET                       = (4 + CFF_UNIFORM_SETTER_IS_TEXTURE_ACTIVATION_ENABLED_CFF_OFFSET);
    static const Int32 CFF_UNIFORM_SETTER_IS_POINT_SPRITE_ACTIVATION_ENABLED_CFF_OFFSET       = (4 + CFF_UNIFORM_SETTER_LIGHT_COORDINATE_SPACE_OFFSET);
    static const Int32 CFF_UNIFORM_SETTER_IS_MORPHING_MESH_ACTIVATION_ENABLED_CFF_OFFSET      = (4 + CFF_UNIFORM_SETTER_IS_POINT_SPRITE_ACTIVATION_ENABLED_CFF_OFFSET);
    static const Int32 CFF_UNIFORM_SETTER_UNIFORMS_PTR_OFFSET                                 = (4 + CFF_UNIFORM_SETTER_IS_MORPHING_MESH_ACTIVATION_ENABLED_CFF_OFFSET);
    static const Int32 CFF_UNIFORM_SETTER_IS_CANVAS_ACTIVATION_ENABLED_CFF_OFFSET             = (CFF_PTR_SIZE + CFF_UNIFORM_SETTER_UNIFORMS_PTR_OFFSET);
    static const Int32 CFF_UNIFORM_SETTER_SIZE                                                = (4 + CFF_UNIFORM_SETTER_IS_CANVAS_ACTIVATION_ENABLED_CFF_OFFSET);

    // getter methods for UniformSetter
    inline bool GetUniformSetterIsModelMatrix4Enabled_Cff(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_UNIFORM_SETTER_IS_MODEL_MATRIX_4ENABLED_CFF_OFFSET);
    }
    inline bool GetUniformSetterIsModelMatrix3Enabled_Cff(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_UNIFORM_SETTER_IS_MODEL_MATRIX_3ENABLED_CFF_OFFSET);
    }
    inline bool GetUniformSetterIsNormalModelMatrix3Enabled_Cff(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_UNIFORM_SETTER_IS_NORMAL_MODEL_MATRIX_3ENABLED_CFF_OFFSET);
    }
    inline bool GetUniformSetterIsModelViewMatrix4Enabled_Cff(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_UNIFORM_SETTER_IS_MODEL_VIEW_MATRIX_4ENABLED_CFF_OFFSET);
    }
    inline bool GetUniformSetterIsModelViewMatrix3Enabled_Cff(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_UNIFORM_SETTER_IS_MODEL_VIEW_MATRIX_3ENABLED_CFF_OFFSET);
    }
    inline bool GetUniformSetterIsNormalModelViewMatrix3Enabled_Cff(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_UNIFORM_SETTER_IS_NORMAL_MODEL_VIEW_MATRIX_3ENABLED_CFF_OFFSET);
    }
    inline bool GetUniformSetterIsProjectionMatrix4Enabled_Cff(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_UNIFORM_SETTER_IS_PROJECTION_MATRIX_4ENABLED_CFF_OFFSET);
    }
    inline bool GetUniformSetterIsModelViewProjectionMatrix4Enabled_Cff(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_UNIFORM_SETTER_IS_MODEL_VIEW_PROJECTION_MATRIX_4ENABLED_CFF_OFFSET);
    }
    inline bool GetUniformSetterIsCameraLookAtVectorEnabled_Cff(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_UNIFORM_SETTER_IS_CAMERA_LOOK_AT_VECTOR_ENABLED_CFF_OFFSET);
    }
    inline bool GetUniformSetterIsCameraPositionEnabled_Cff(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_UNIFORM_SETTER_IS_CAMERA_POSITION_ENABLED_CFF_OFFSET);
    }
    inline bool GetUniformSetterIsLightsActivationEnabled_Cff(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_UNIFORM_SETTER_IS_LIGHTS_ACTIVATION_ENABLED_CFF_OFFSET);
    }
    inline bool GetUniformSetterIsMaterialActivationEnabled_Cff(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_UNIFORM_SETTER_IS_MATERIAL_ACTIVATION_ENABLED_CFF_OFFSET);
    }
    inline bool GetUniformSetterIsTextureActivationEnabled_Cff(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_UNIFORM_SETTER_IS_TEXTURE_ACTIVATION_ENABLED_CFF_OFFSET);
    }
    inline Int32 GetUniformSetterLightCoordinateSpace(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_UNIFORM_SETTER_LIGHT_COORDINATE_SPACE_OFFSET);
    }
    inline bool GetUniformSetterIsPointSpriteActivationEnabled_Cff(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_UNIFORM_SETTER_IS_POINT_SPRITE_ACTIVATION_ENABLED_CFF_OFFSET);
    }
    inline bool GetUniformSetterIsMorphingMeshActivationEnabled_Cff(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_UNIFORM_SETTER_IS_MORPHING_MESH_ACTIVATION_ENABLED_CFF_OFFSET);
    }
    inline Int32 GetUniformSetterUniformsDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_UNIFORM_SETTER_UNIFORMS_PTR_OFFSET)); 
    }
    inline Int32 GetUniformSetterUniformsCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_UNIFORM_SETTER_UNIFORMS_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline AssetDataHandle GetUniformSetterUniformsElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 listOffset = CffGetValSafe<Int32>(handle, CFF_UNIFORM_SETTER_UNIFORMS_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_PTR_SIZE)));
    }
    inline bool GetUniformSetterIsCanvasActivationEnabled_Cff(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_UNIFORM_SETTER_IS_CANVAS_ACTIVATION_ENABLED_CFF_OFFSET);
    }

}}} //namespaces

#endif //UniformSetter_CffReader_H
