//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Uniform_CffReader_H
#define Uniform_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Uniform
    static const Int32 CFF_UNIFORM_ITEM_SIZE_OFFSET                                           = (0);
    static const Int32 CFF_UNIFORM_NAME_OFFSET                                                = (4 + CFF_UNIFORM_ITEM_SIZE_OFFSET);
    static const Int32 CFF_UNIFORM_TYPE_OFFSET                                                = (4 + CFF_UNIFORM_NAME_OFFSET);
    static const Int32 CFF_UNIFORM_VALUE_OFFSET                                               = (4 + CFF_UNIFORM_TYPE_OFFSET);
    static const Int32 CFF_UNIFORM_SIZE                                                       = (4 + CFF_UNIFORM_VALUE_OFFSET);

    // getter methods for Uniform
    inline Int32 GetUniformItemSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_UNIFORM_ITEM_SIZE_OFFSET);
    }
    inline Int32 GetUniformName(const AssetDataHandle& handle)
    {
        Int32 nameIndex = CffGetValSafe<Int32>(handle, CFF_UNIFORM_NAME_OFFSET);
        return nameIndex;
    }
    inline Int32 GetUniformType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_UNIFORM_TYPE_OFFSET);
    }
    inline const void* GetUniformValue(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<void>(handle, CFF_UNIFORM_VALUE_OFFSET);
    }

}}} //namespaces

#endif //Uniform_CffReader_H
