//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef TransitionRule_CffReader_H
#define TransitionRule_CffReader_H

#include "CanderaObjectCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for TransitionRule
    static const Int32 CFF_TRANSITION_RULE_SOURCE_IDENTIFIER_OFFSET                           = (CFF_CANDERA_OBJECT_SIZE);
    static const Int32 CFF_TRANSITION_RULE_SOURCE_ITEM_OFFSET                                 = (4 + CFF_TRANSITION_RULE_SOURCE_IDENTIFIER_OFFSET);
    static const Int32 CFF_TRANSITION_RULE_DESTINATION_IDENTIFIER_OFFSET                      = (16 + CFF_TRANSITION_RULE_SOURCE_ITEM_OFFSET);
    static const Int32 CFF_TRANSITION_RULE_DESTINATION_ITEM_OFFSET                            = (4 + CFF_TRANSITION_RULE_DESTINATION_IDENTIFIER_OFFSET);
    static const Int32 CFF_TRANSITION_RULE_VARIANT_OFFSET                                     = (16 + CFF_TRANSITION_RULE_DESTINATION_ITEM_OFFSET);
    static const Int32 CFF_TRANSITION_RULE_PARAMS_PTR_OFFSET                                  = (4 + CFF_TRANSITION_RULE_VARIANT_OFFSET);
    static const Int32 CFF_TRANSITION_RULE_FACTORY_OFFSET                                     = (CFF_PTR_SIZE + CFF_TRANSITION_RULE_PARAMS_PTR_OFFSET);
    static const Int32 CFF_TRANSITION_RULE_IS_REVERSIBLE_OFFSET                               = (4 + CFF_TRANSITION_RULE_FACTORY_OFFSET);
    static const Int32 CFF_TRANSITION_RULE_IS_BIDIRECTIONAL_OFFSET                            = (4 + CFF_TRANSITION_RULE_IS_REVERSIBLE_OFFSET);
    static const Int32 CFF_TRANSITION_RULE_SIZE                                               = (4 + CFF_TRANSITION_RULE_IS_BIDIRECTIONAL_OFFSET);

    // getter methods for TransitionRule
    inline Int32 GetTransitionRuleSourceIdentifier(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TRANSITION_RULE_SOURCE_IDENTIFIER_OFFSET);
    }
    inline const UInt32* GetTransitionRuleSourceItem(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_TRANSITION_RULE_SOURCE_ITEM_OFFSET);
    }
    inline Int32 GetTransitionRuleDestinationIdentifier(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TRANSITION_RULE_DESTINATION_IDENTIFIER_OFFSET);
    }
    inline const UInt32* GetTransitionRuleDestinationItem(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_TRANSITION_RULE_DESTINATION_ITEM_OFFSET);
    }
    inline Int32 GetTransitionRuleVariant(const AssetDataHandle& handle)
    {
        Int32 nameIndex = CffGetValSafe<Int32>(handle, CFF_TRANSITION_RULE_VARIANT_OFFSET);
        return nameIndex;
    }
    inline AssetDataHandle GetTransitionRuleParams(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_TRANSITION_RULE_PARAMS_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }
    inline Int32 GetTransitionRuleFactory(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TRANSITION_RULE_FACTORY_OFFSET);
    }
    inline bool GetTransitionRuleIsReversible(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_TRANSITION_RULE_IS_REVERSIBLE_OFFSET);
    }
    inline bool GetTransitionRuleIsBidirectional(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_TRANSITION_RULE_IS_BIDIRECTIONAL_OFFSET);
    }

}}} //namespaces

#endif //TransitionRule_CffReader_H
