//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef TransitionParams_CffReader_H
#define TransitionParams_CffReader_H

#include "SCItemCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for TransitionParams
    static const Int32 CFF_TRANSITION_PARAMS_IS_FADE_ENABLED_OFFSET                           = (CFF_SC_ITEM_SIZE);
    static const Int32 CFF_TRANSITION_PARAMS_FADE_OFFSET                                      = (4 + CFF_TRANSITION_PARAMS_IS_FADE_ENABLED_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_IS_FADE_TIMELINE_ENABLED_OFFSET                  = (4 + CFF_TRANSITION_PARAMS_FADE_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_FADE_TIMELINE_OFFSET                             = (4 + CFF_TRANSITION_PARAMS_IS_FADE_TIMELINE_ENABLED_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_IS_SLIDE_ENABLED_OFFSET                          = (8 + CFF_TRANSITION_PARAMS_FADE_TIMELINE_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_SLIDE_OFFSET                                     = (4 + CFF_TRANSITION_PARAMS_IS_SLIDE_ENABLED_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_IS_SLIDE_TIMELINE_ENABLED_OFFSET                 = (12 + CFF_TRANSITION_PARAMS_SLIDE_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_SLIDE_TIMELINE_OFFSET                            = (4 + CFF_TRANSITION_PARAMS_IS_SLIDE_TIMELINE_ENABLED_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_IS_SLIDE_RELATIVE_OFFSET                         = (8 + CFF_TRANSITION_PARAMS_SLIDE_TIMELINE_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_IS_SCALE_ENABLED_OFFSET                          = (4 + CFF_TRANSITION_PARAMS_IS_SLIDE_RELATIVE_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_SCALE_OFFSET                                     = (4 + CFF_TRANSITION_PARAMS_IS_SCALE_ENABLED_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_IS_SCALE_TIMELINE_ENABLED_OFFSET                 = (12 + CFF_TRANSITION_PARAMS_SCALE_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_SCALE_TIMELINE_OFFSET                            = (4 + CFF_TRANSITION_PARAMS_IS_SCALE_TIMELINE_ENABLED_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_IS_SCALE_RELATIVE_OFFSET                         = (8 + CFF_TRANSITION_PARAMS_SCALE_TIMELINE_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_IS_ANIMATION_ENABLED_OFFSET                      = (4 + CFF_TRANSITION_PARAMS_IS_SCALE_RELATIVE_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_ANIMATION_ITEM_OFFSET                            = (4 + CFF_TRANSITION_PARAMS_IS_ANIMATION_ENABLED_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_IS_ANIMATION_TIMELINE_ENABLED_OFFSET             = (16 + CFF_TRANSITION_PARAMS_ANIMATION_ITEM_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_ANIMATION_TIMELINE_OFFSET                        = (4 + CFF_TRANSITION_PARAMS_IS_ANIMATION_TIMELINE_ENABLED_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_IS_ANIMATION_TIME_RELATIVE_OFFSET                = (8 + CFF_TRANSITION_PARAMS_ANIMATION_TIMELINE_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_ACTIVATION_STRATEGY_OFFSET                       = (4 + CFF_TRANSITION_PARAMS_IS_ANIMATION_TIME_RELATIVE_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_DEACTIVATION_STRATEGY_OFFSET                     = (4 + CFF_TRANSITION_PARAMS_ACTIVATION_STRATEGY_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_ACTIVATION_STRATEGY_DELAY_OFFSET                 = (4 + CFF_TRANSITION_PARAMS_DEACTIVATION_STRATEGY_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_DEACTIVATION_STRATEGY_DELAY_OFFSET               = (4 + CFF_TRANSITION_PARAMS_ACTIVATION_STRATEGY_DELAY_OFFSET);
    static const Int32 CFF_TRANSITION_PARAMS_SIZE                                             = (4 + CFF_TRANSITION_PARAMS_DEACTIVATION_STRATEGY_DELAY_OFFSET);

    // getter methods for TransitionParams
    inline bool GetTransitionParamsIsFadeEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_TRANSITION_PARAMS_IS_FADE_ENABLED_OFFSET);
    }
    inline Float GetTransitionParamsFade(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_TRANSITION_PARAMS_FADE_OFFSET);
    }
    inline bool GetTransitionParamsIsFadeTimelineEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_TRANSITION_PARAMS_IS_FADE_TIMELINE_ENABLED_OFFSET);
    }
    inline void GetTransitionParamsFadeTimeline(const AssetDataHandle& handle, Float& startTime, Float& stopTime)
    {
        startTime = CffGetValSafe<Float>(handle, CFF_TRANSITION_PARAMS_FADE_TIMELINE_OFFSET);
        stopTime = CffGetValSafe<Float>(handle, CFF_TRANSITION_PARAMS_FADE_TIMELINE_OFFSET + (1 * CFF_FLOAT_SIZE));
    }
    inline bool GetTransitionParamsIsSlideEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_TRANSITION_PARAMS_IS_SLIDE_ENABLED_OFFSET);
    }
    inline void GetTransitionParamsSlide(const AssetDataHandle& handle, Float& x, Float& y, Float& z)
    {
        x = CffGetValSafe<Float>(handle, CFF_TRANSITION_PARAMS_SLIDE_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_TRANSITION_PARAMS_SLIDE_OFFSET + (1 * CFF_FLOAT_SIZE));
        z = CffGetValSafe<Float>(handle, CFF_TRANSITION_PARAMS_SLIDE_OFFSET + (2 * CFF_FLOAT_SIZE));
    }
    inline bool GetTransitionParamsIsSlideTimelineEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_TRANSITION_PARAMS_IS_SLIDE_TIMELINE_ENABLED_OFFSET);
    }
    inline void GetTransitionParamsSlideTimeline(const AssetDataHandle& handle, Float& startTime, Float& stopTime)
    {
        startTime = CffGetValSafe<Float>(handle, CFF_TRANSITION_PARAMS_SLIDE_TIMELINE_OFFSET);
        stopTime = CffGetValSafe<Float>(handle, CFF_TRANSITION_PARAMS_SLIDE_TIMELINE_OFFSET + (1 * CFF_FLOAT_SIZE));
    }
    inline bool GetTransitionParamsIsSlideRelative(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_TRANSITION_PARAMS_IS_SLIDE_RELATIVE_OFFSET);
    }
    inline bool GetTransitionParamsIsScaleEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_TRANSITION_PARAMS_IS_SCALE_ENABLED_OFFSET);
    }
    inline void GetTransitionParamsScale(const AssetDataHandle& handle, Float& x, Float& y, Float& z)
    {
        x = CffGetValSafe<Float>(handle, CFF_TRANSITION_PARAMS_SCALE_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_TRANSITION_PARAMS_SCALE_OFFSET + (1 * CFF_FLOAT_SIZE));
        z = CffGetValSafe<Float>(handle, CFF_TRANSITION_PARAMS_SCALE_OFFSET + (2 * CFF_FLOAT_SIZE));
    }
    inline bool GetTransitionParamsIsScaleTimelineEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_TRANSITION_PARAMS_IS_SCALE_TIMELINE_ENABLED_OFFSET);
    }
    inline void GetTransitionParamsScaleTimeline(const AssetDataHandle& handle, Float& startTime, Float& stopTime)
    {
        startTime = CffGetValSafe<Float>(handle, CFF_TRANSITION_PARAMS_SCALE_TIMELINE_OFFSET);
        stopTime = CffGetValSafe<Float>(handle, CFF_TRANSITION_PARAMS_SCALE_TIMELINE_OFFSET + (1 * CFF_FLOAT_SIZE));
    }
    inline bool GetTransitionParamsIsScaleRelative(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_TRANSITION_PARAMS_IS_SCALE_RELATIVE_OFFSET);
    }
    inline bool GetTransitionParamsIsAnimationEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_TRANSITION_PARAMS_IS_ANIMATION_ENABLED_OFFSET);
    }
    inline const UInt32* GetTransitionParamsAnimationItem(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_TRANSITION_PARAMS_ANIMATION_ITEM_OFFSET);
    }
    inline bool GetTransitionParamsIsAnimationTimelineEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_TRANSITION_PARAMS_IS_ANIMATION_TIMELINE_ENABLED_OFFSET);
    }
    inline void GetTransitionParamsAnimationTimeline(const AssetDataHandle& handle, Float& startTime, Float& stopTime)
    {
        startTime = CffGetValSafe<Float>(handle, CFF_TRANSITION_PARAMS_ANIMATION_TIMELINE_OFFSET);
        stopTime = CffGetValSafe<Float>(handle, CFF_TRANSITION_PARAMS_ANIMATION_TIMELINE_OFFSET + (1 * CFF_FLOAT_SIZE));
    }
    inline bool GetTransitionParamsIsAnimationTimeRelative(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_TRANSITION_PARAMS_IS_ANIMATION_TIME_RELATIVE_OFFSET);
    }
    inline Int32 GetTransitionParamsActivationStrategy(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TRANSITION_PARAMS_ACTIVATION_STRATEGY_OFFSET);
    }
    inline Int32 GetTransitionParamsDeactivationStrategy(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TRANSITION_PARAMS_DEACTIVATION_STRATEGY_OFFSET);
    }
    inline Float GetTransitionParamsActivationStrategyDelay(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_TRANSITION_PARAMS_ACTIVATION_STRATEGY_DELAY_OFFSET);
    }
    inline Float GetTransitionParamsDeactivationStrategyDelay(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_TRANSITION_PARAMS_DEACTIVATION_STRATEGY_DELAY_OFFSET);
    }

}}} //namespaces

#endif //TransitionParams_CffReader_H
