//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef TextStyleCulture_CffReader_H
#define TextStyleCulture_CffReader_H

#include "CanderaObjectCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for TextStyleCulture
    static const Int32 CFF_TEXT_STYLE_CULTURE_CULTURE_LOCALE_NAME_OFFSET                      = (CFF_CANDERA_OBJECT_SIZE);
    static const Int32 CFF_TEXT_STYLE_CULTURE_CHILDREN_PTR_OFFSET                             = (4 + CFF_TEXT_STYLE_CULTURE_CULTURE_LOCALE_NAME_OFFSET);
    static const Int32 CFF_TEXT_STYLE_CULTURE_SIZE                                            = (CFF_PTR_SIZE + CFF_TEXT_STYLE_CULTURE_CHILDREN_PTR_OFFSET);

    // getter methods for TextStyleCulture
    inline Int32 GetTextStyleCultureCultureLocaleName(const AssetDataHandle& handle)
    {
        Int32 nameIndex = CffGetValSafe<Int32>(handle, CFF_TEXT_STYLE_CULTURE_CULTURE_LOCALE_NAME_OFFSET);
        return nameIndex;
    }
    inline Int32 GetTextStyleCultureChildrenDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_TEXT_STYLE_CULTURE_CHILDREN_PTR_OFFSET)); 
    }
    inline Int32 GetTextStyleCultureChildrenCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_TEXT_STYLE_CULTURE_CHILDREN_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline AssetDataHandle GetTextStyleCultureChildrenElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 listOffset = CffGetValSafe<Int32>(handle, CFF_TEXT_STYLE_CULTURE_CHILDREN_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_PTR_SIZE)));
    }

}}} //namespaces

#endif //TextStyleCulture_CffReader_H
