//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef TextStyle_CffReader_H
#define TextStyle_CffReader_H

#include "CanderaObjectCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for TextStyle
    static const Int32 CFF_TEXT_STYLE_BASE_STYLE_OFFSET                                       = (CFF_CANDERA_OBJECT_SIZE);
    static const Int32 CFF_TEXT_STYLE_DEFAULT_FONT_PTR_OFFSET                                 = (16 + CFF_TEXT_STYLE_BASE_STYLE_OFFSET);
    static const Int32 CFF_TEXT_STYLE_CHILDREN_PTR_OFFSET                                     = (CFF_PTR_SIZE + CFF_TEXT_STYLE_DEFAULT_FONT_PTR_OFFSET);
    static const Int32 CFF_TEXT_STYLE_CULTURES_PTR_OFFSET                                     = (CFF_PTR_SIZE + CFF_TEXT_STYLE_CHILDREN_PTR_OFFSET);
    static const Int32 CFF_TEXT_STYLE_SIZE                                                    = (CFF_PTR_SIZE + CFF_TEXT_STYLE_CULTURES_PTR_OFFSET);

    // getter methods for TextStyle
    inline const UInt32* GetTextStyleBaseStyle(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_TEXT_STYLE_BASE_STYLE_OFFSET);
    }
    inline AssetDataHandle GetTextStyleDefaultFont(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_TEXT_STYLE_DEFAULT_FONT_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }
    inline Int32 GetTextStyleChildrenDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_TEXT_STYLE_CHILDREN_PTR_OFFSET)); 
    }
    inline Int32 GetTextStyleChildrenCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_TEXT_STYLE_CHILDREN_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline AssetDataHandle GetTextStyleChildrenElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 listOffset = CffGetValSafe<Int32>(handle, CFF_TEXT_STYLE_CHILDREN_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_PTR_SIZE)));
    }
    inline Int32 GetTextStyleCulturesDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_TEXT_STYLE_CULTURES_PTR_OFFSET)); 
    }
    inline Int32 GetTextStyleCulturesCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_TEXT_STYLE_CULTURES_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline AssetDataHandle GetTextStyleCulturesElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 listOffset = CffGetValSafe<Int32>(handle, CFF_TEXT_STYLE_CULTURES_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_PTR_SIZE)));
    }

}}} //namespaces

#endif //TextStyle_CffReader_H
