//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef StereoCamera_CffReader_H
#define StereoCamera_CffReader_H

#include "Node3DCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for StereoCamera
    static const Int32 CFF_STEREO_CAMERA_LEFT_EYE_OFFSET                                      = (CFF_NODE_3D_SIZE);
    static const Int32 CFF_STEREO_CAMERA_RIGHT_EYE_OFFSET                                     = (16 + CFF_STEREO_CAMERA_LEFT_EYE_OFFSET);
    static const Int32 CFF_STEREO_CAMERA_EYE_SEPARATION_OFFSET                                = (16 + CFF_STEREO_CAMERA_RIGHT_EYE_OFFSET);
    static const Int32 CFF_STEREO_CAMERA_CONVERGENCE_DISTANCE_OFFSET                          = (4 + CFF_STEREO_CAMERA_EYE_SEPARATION_OFFSET);
    static const Int32 CFF_STEREO_CAMERA_SIZE                                                 = (4 + CFF_STEREO_CAMERA_CONVERGENCE_DISTANCE_OFFSET);

    // getter methods for StereoCamera
    inline const UInt32* GetStereoCameraLeftEye(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_STEREO_CAMERA_LEFT_EYE_OFFSET);
    }
    inline const UInt32* GetStereoCameraRightEye(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_STEREO_CAMERA_RIGHT_EYE_OFFSET);
    }
    inline Float GetStereoCameraEyeSeparation(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_STEREO_CAMERA_EYE_SEPARATION_OFFSET);
    }
    inline Float GetStereoCameraConvergenceDistance(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_STEREO_CAMERA_CONVERGENCE_DISTANCE_OFFSET);
    }

}}} //namespaces

#endif //StereoCamera_CffReader_H
