//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef StateMachine_CffReader_H
#define StateMachine_CffReader_H

#include "CanderaObjectCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for StateMachine
    static const Int32 CFF_STATE_MACHINE_CONDITIONS_PTR_OFFSET                                = (CFF_CANDERA_OBJECT_SIZE);
    static const Int32 CFF_STATE_MACHINE_ACTIONS_PTR_OFFSET                                   = (CFF_PTR_SIZE + CFF_STATE_MACHINE_CONDITIONS_PTR_OFFSET);
    static const Int32 CFF_STATE_MACHINE_STATES_PTR_OFFSET                                    = (CFF_PTR_SIZE + CFF_STATE_MACHINE_ACTIONS_PTR_OFFSET);
    static const Int32 CFF_STATE_MACHINE_STATE_TRANSITIONS_PTR_OFFSET                         = (CFF_PTR_SIZE + CFF_STATE_MACHINE_STATES_PTR_OFFSET);
    static const Int32 CFF_STATE_MACHINE_IS_GLOBAL_OFFSET                                     = (CFF_PTR_SIZE + CFF_STATE_MACHINE_STATE_TRANSITIONS_PTR_OFFSET);
    static const Int32 CFF_STATE_MACHINE_NO_PARENT_STATES_OFFSET                              = (4 + CFF_STATE_MACHINE_IS_GLOBAL_OFFSET);
    static const Int32 CFF_STATE_MACHINE_SIZE                                                 = (4 + CFF_STATE_MACHINE_NO_PARENT_STATES_OFFSET);

    // getter methods for StateMachine
    inline Int32 GetStateMachineConditionsDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_STATE_MACHINE_CONDITIONS_PTR_OFFSET)); 
    }
    inline Int32 GetStateMachineConditionsCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_STATE_MACHINE_CONDITIONS_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline AssetDataHandle GetStateMachineConditionsElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 listOffset = CffGetValSafe<Int32>(handle, CFF_STATE_MACHINE_CONDITIONS_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_PTR_SIZE)));
    }
    inline Int32 GetStateMachineActionsDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_STATE_MACHINE_ACTIONS_PTR_OFFSET)); 
    }
    inline Int32 GetStateMachineActionsCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_STATE_MACHINE_ACTIONS_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline AssetDataHandle GetStateMachineActionsElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 listOffset = CffGetValSafe<Int32>(handle, CFF_STATE_MACHINE_ACTIONS_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_PTR_SIZE)));
    }
    inline Int32 GetStateMachineStatesDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_STATE_MACHINE_STATES_PTR_OFFSET)); 
    }
    inline Int32 GetStateMachineStatesCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_STATE_MACHINE_STATES_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline AssetDataHandle GetStateMachineStatesElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 listOffset = CffGetValSafe<Int32>(handle, CFF_STATE_MACHINE_STATES_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_PTR_SIZE)));
    }
    inline Int32 GetStateMachineStateTransitionsDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_STATE_MACHINE_STATE_TRANSITIONS_PTR_OFFSET)); 
    }
    inline Int32 GetStateMachineStateTransitionsCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_STATE_MACHINE_STATE_TRANSITIONS_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline AssetDataHandle GetStateMachineStateTransitionsElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 listOffset = CffGetValSafe<Int32>(handle, CFF_STATE_MACHINE_STATE_TRANSITIONS_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_PTR_SIZE)));
    }
    inline bool GetStateMachineIsGlobal(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_STATE_MACHINE_IS_GLOBAL_OFFSET);
    }
    inline Int32 GetStateMachineNoParentStates(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_STATE_MACHINE_NO_PARENT_STATES_OFFSET);
    }

}}} //namespaces

#endif //StateMachine_CffReader_H
