//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef ScriptComponent_CffReader_H
#define ScriptComponent_CffReader_H

#include "CanderaObjectCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for ScriptComponent
    static const Int32 CFF_SCRIPT_COMPONENT_SCRIPT_OFFSET                                     = (CFF_CANDERA_OBJECT_SIZE);
    static const Int32 CFF_SCRIPT_COMPONENT_PARAMETERS_PTR_OFFSET                             = (16 + CFF_SCRIPT_COMPONENT_SCRIPT_OFFSET);
    static const Int32 CFF_SCRIPT_COMPONENT_IS_ENABLED_OFFSET                                 = (CFF_PTR_SIZE + CFF_SCRIPT_COMPONENT_PARAMETERS_PTR_OFFSET);
    static const Int32 CFF_SCRIPT_COMPONENT_PRIORITY_OFFSET                                   = (4 + CFF_SCRIPT_COMPONENT_IS_ENABLED_OFFSET);
    static const Int32 CFF_SCRIPT_COMPONENT_SIZE                                              = (4 + CFF_SCRIPT_COMPONENT_PRIORITY_OFFSET);

    // getter methods for ScriptComponent
    inline const UInt32* GetScriptComponentScript(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_SCRIPT_COMPONENT_SCRIPT_OFFSET);
    }
    inline Int32 GetScriptComponentParametersDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_SCRIPT_COMPONENT_PARAMETERS_PTR_OFFSET)); 
    }
    inline Int32 GetScriptComponentParametersCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_SCRIPT_COMPONENT_PARAMETERS_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline AssetDataHandle GetScriptComponentParametersElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 listOffset = CffGetValSafe<Int32>(handle, CFF_SCRIPT_COMPONENT_PARAMETERS_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_PTR_SIZE)));
    }
    inline bool GetScriptComponentIsEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_SCRIPT_COMPONENT_IS_ENABLED_OFFSET);
    }
    inline Float GetScriptComponentPriority(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_SCRIPT_COMPONENT_PRIORITY_OFFSET);
    }

}}} //namespaces

#endif //ScriptComponent_CffReader_H
