//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef SceneAnimationInfo_CffReader_H
#define SceneAnimationInfo_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for SceneAnimationInfo
    static const Int32 CFF_SCENE_ANIMATION_INFO_ANIMATION_OFFSET                              = (0);
    static const Int32 CFF_SCENE_ANIMATION_INFO_ANIMATED_PROPERTIES_PTR_OFFSET                = (16 + CFF_SCENE_ANIMATION_INFO_ANIMATION_OFFSET);
    static const Int32 CFF_SCENE_ANIMATION_INFO_SIZE                                          = (CFF_PTR_SIZE + CFF_SCENE_ANIMATION_INFO_ANIMATED_PROPERTIES_PTR_OFFSET);

    // getter methods for SceneAnimationInfo
    inline const UInt32* GetSceneAnimationInfoAnimation(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_SCENE_ANIMATION_INFO_ANIMATION_OFFSET);
    }
    inline Int32 GetSceneAnimationInfoAnimatedPropertiesDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_SCENE_ANIMATION_INFO_ANIMATED_PROPERTIES_PTR_OFFSET)); 
    }
    inline Int32 GetSceneAnimationInfoAnimatedPropertiesCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_SCENE_ANIMATION_INFO_ANIMATED_PROPERTIES_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline AssetDataHandle GetSceneAnimationInfoAnimatedPropertiesElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 listOffset = CffGetValSafe<Int32>(handle, CFF_SCENE_ANIMATION_INFO_ANIMATED_PROPERTIES_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_PTR_SIZE)));
    }

}}} //namespaces

#endif //SceneAnimationInfo_CffReader_H
