//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Scene3D_CffReader_H
#define Scene3D_CffReader_H

#include "SceneCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Scene3D
    static const Int32 CFF_SCENE_3D_RENDER_ORDER_BINS_PTR_OFFSET                              = (CFF_SCENE_SIZE);
    static const Int32 CFF_SCENE_3D_SIZE                                                      = (CFF_PTR_SIZE + CFF_SCENE_3D_RENDER_ORDER_BINS_PTR_OFFSET);

    // getter methods for Scene3D
    inline AssetDataHandle GetScene3DRenderOrderBins(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_SCENE_3D_RENDER_ORDER_BINS_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }

}}} //namespaces

#endif //Scene3D_CffReader_H
