//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef RenderOrderBin_CffReader_H
#define RenderOrderBin_CffReader_H

#include "CanderaObjectCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for RenderOrderBin
    static const Int32 CFF_RENDER_ORDER_BIN_IS_SORTING_ENABLED_OFFSET                         = (CFF_CANDERA_OBJECT_SIZE);
    static const Int32 CFF_RENDER_ORDER_BIN_CRITERION_OFFSET                                  = (4 + CFF_RENDER_ORDER_BIN_IS_SORTING_ENABLED_OFFSET);
    static const Int32 CFF_RENDER_ORDER_BIN_BATCH_ORDER_OFFSET                                = (4 + CFF_RENDER_ORDER_BIN_CRITERION_OFFSET);
    static const Int32 CFF_RENDER_ORDER_BIN_DISTANCE_FUNCTION_OFFSET                          = (4 + CFF_RENDER_ORDER_BIN_BATCH_ORDER_OFFSET);
    static const Int32 CFF_RENDER_ORDER_BIN_SIZE_HINT_OFFSET                                  = (4 + CFF_RENDER_ORDER_BIN_DISTANCE_FUNCTION_OFFSET);
    static const Int32 CFF_RENDER_ORDER_BIN_SIZE                                              = (4 + CFF_RENDER_ORDER_BIN_SIZE_HINT_OFFSET);

    // getter methods for RenderOrderBin
    inline bool GetRenderOrderBinIsSortingEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_RENDER_ORDER_BIN_IS_SORTING_ENABLED_OFFSET);
    }
    inline Int32 GetRenderOrderBinCriterion(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_ORDER_BIN_CRITERION_OFFSET);
    }
    inline Int32 GetRenderOrderBinBatchOrder(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_ORDER_BIN_BATCH_ORDER_OFFSET);
    }
    inline Int32 GetRenderOrderBinDistanceFunction(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_ORDER_BIN_DISTANCE_FUNCTION_OFFSET);
    }
    inline Int32 GetRenderOrderBinSizeHint(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_ORDER_BIN_SIZE_HINT_OFFSET);
    }

}}} //namespaces

#endif //RenderOrderBin_CffReader_H
