//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef RenderNode2D_CffReader_H
#define RenderNode2D_CffReader_H

#include "Node2DCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for RenderNode2D
    static const Int32 CFF_RENDER_NODE_2D_IS_SNAP_TO_DEVICE_PIXEL_ENABLED_OFFSET              = (CFF_NODE_2D_SIZE);
    static const Int32 CFF_RENDER_NODE_2D_EFFECTS_PTR_OFFSET                                  = (4 + CFF_RENDER_NODE_2D_IS_SNAP_TO_DEVICE_PIXEL_ENABLED_OFFSET);
    static const Int32 CFF_RENDER_NODE_2D_SIZE                                                = (CFF_PTR_SIZE + CFF_RENDER_NODE_2D_EFFECTS_PTR_OFFSET);

    // getter methods for RenderNode2D
    inline bool GetRenderNode2DIsSnapToDevicePixelEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_RENDER_NODE_2D_IS_SNAP_TO_DEVICE_PIXEL_ENABLED_OFFSET);
    }
    inline AssetDataHandle GetRenderNode2DEffects(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_RENDER_NODE_2D_EFFECTS_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }

}}} //namespaces

#endif //RenderNode2D_CffReader_H
